package ext.grid.locking.events {
import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.grid.locking.events.Lockable_lockedColumns_normalColumnsEvent")]
public class Lockable_lockedColumns_normalColumnsEvent extends FlExtEvent {
  /**
   * Fires when the configured (or <b>reconfigured</b>) column set is split into two
   * depending on the →<code>ext.grid.column.Column.locked</code> flag.
   * @see ext.grid.column.Column#locked
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#event-processcolumns Original Ext JS documentation of 'processcolumns'
   * @see ext.grid.locking.Lockable
   * @eventType onProcessColumns
   */
  public static const PROCESS_COLUMNS:String = "onProcessColumns";
  public static const __PARAMETER_SEQUENCE__:Array = ["lockedColumns", "normalColumns", "eOpts"];

  public function Lockable_lockedColumns_normalColumnsEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  [ArrayElementType("ext.grid.column.Column")]
  /**
   * The locked columns.
   */
  public native function get lockedColumns():Array;

  [ArrayElementType("ext.grid.column.Column")]
  /**
   * The normal columns.
   */
  public native function get normalColumns():Array;
}
}