package ext.grid.plugin {
import ext.grid.CellContext;

[Native("Ext.grid.plugin.CellEditing", require)]
/**
 * @see ext.grid.plugin.events.CellEditingPlugin_contextEvent.BEFORE_EDIT
 * @eventType ext.grid.plugin.events.CellEditingPlugin_contextEvent.BEFORE_EDIT
 */
[Event(name='onBeforeEdit', type='ext.grid.plugin.events.CellEditingPlugin_contextEvent')]
/**
 * @see ext.grid.plugin.events.CellEditingPlugin_contextEvent.CANCEL_EDIT
 * @eventType ext.grid.plugin.events.CellEditingPlugin_contextEvent.CANCEL_EDIT
 */
[Event(name='onCancelEdit', type='ext.grid.plugin.events.CellEditingPlugin_contextEvent')]
/**
 * @see ext.grid.plugin.events.CellEditingPlugin_contextEvent.EDIT
 * @eventType ext.grid.plugin.events.CellEditingPlugin_contextEvent.EDIT
 */
[Event(name='onEdit', type='ext.grid.plugin.events.CellEditingPlugin_contextEvent')]
/**
 * @see ext.grid.plugin.events.CellEditingPlugin_contextEvent.VALIDATE_EDIT
 * @eventType ext.grid.plugin.events.CellEditingPlugin_contextEvent.VALIDATE_EDIT
 */
[Event(name='onValidateEdit', type='ext.grid.plugin.events.CellEditingPlugin_contextEvent')]
/**
 * The Ext.grid.plugin.CellEditing plugin injects editing at a cell level for a Grid. Only a single
 * cell will be editable at a time. The field that will be used for the editor is defined at the
 * →<code>ext.grid.column.Column.editor</code>. The editor can be a field instance or a field
 * configuration.
 * <p>If an editor is not specified for a particular column then that cell will not be editable
 * and it will be skipped when activated via the mouse or the keyboard.</p>
 * <p>The editor may be shared for each column in the grid, or a different one may be specified
 * for each column. An appropriate field type should be chosen to match the data structure
 * that it will be editing. For example, to edit a date, it would be useful to specify
 * →<code>ext.form.field.DateField</code> as the editor.</p>
 * <p>If the <code>editor</code> config on a column contains a <code>field</code> property, then the <code>editor</code> config
 * is used to create the wrapping →<code>null</code>, and the <code>field</code> property
 * is used to create the editing input field.</p>
 * <p><b><i>Example</i></b></p>
 * <p>A grid with editor for the name and the email columns:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.data.Store', {
 *     storeId: 'simpsonsStore',
 *     fields:[ 'name', 'email', 'phone'],
 *     data: [
 *         { name: 'Lisa', email: 'lisa&#64;simpsons.com', phone: '555-111-1224' },
 *         { name: 'Bart', email: 'bart&#64;simpsons.com', phone: '555-222-1234' },
 *         { name: 'Homer', email: 'homer&#64;simpsons.com', phone: '555-222-1244' },
 *         { name: 'Marge', email: 'marge&#64;simpsons.com', phone: '555-222-1254' }
 *     ]
 * });
 *
 * Ext.create('Ext.grid.Panel', {
 *     title: 'Simpsons',
 *     store: Ext.data.StoreManager.lookup('simpsonsStore'),
 *     columns: [
 *         {header: 'Name', dataIndex: 'name', editor: 'textfield'},
 *         {header: 'Email', dataIndex: 'email', flex:1,
 *             editor: {
 *                 completeOnEnter: false,
 *
 *                 // If the editor config contains a field property, then
 *                 // the editor config is used to create the CellEditor
 *                 // and the field property is used to create the editing input field.
 *                 field: {
 *                     xtype: 'textfield',
 *                     allowBlank: false
 *                 }
 *             }
 *         },
 *         {header: 'Phone', dataIndex: 'phone'}
 *     ],
 *     selModel: 'cellmodel',
 *     plugins: {
 *         cellediting: {
 *             clicksToEdit: 1
 *         }
 *     },
 *     height: 200,
 *     width: 400,
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * <p>This requires a little explanation. We're passing in <code>store</code> and <code>columns</code> as normal, but
 * we also specify a →<code>ext.grid.column.Column.field</code> on two of our columns. For the
 * Name column we just want a default textfield to edit the value, so we specify 'textfield'.
 * For the Email column we customized the editor slightly by passing allowBlank: false, which
 * will provide inline validation.</p>
 * <p>To support cell editing, we also specified that the grid should use the 'cellmodel'
 * →<code>ext.grid.GridPanel.selModel</code>, and created an instance of the CellEditing plugin,
 * which we configured to activate each editor after a single click.</p>
 * @see ext.grid.column.Column#editor
 * @see ext.form.field.DateField
 * @see null
 * @see ext.grid.column.Column#field
 * @see ext.grid.GridPanel#selModel
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.CellEditing.html Original Ext JS documentation of 'Ext.grid.plugin.CellEditing'
 */
public class CellEditingPlugin extends GridEditingPlugin {
  /**
   * @param config @inheritDoc
   */
  public function CellEditingPlugin(config:CellEditingPlugin = null) {
    super();
  }

  /**
   * This method is called when actionable mode is requested for a cell.
   * @param position The position at which actionable mode was requested.
   * @param skipBeforeCheck Pass <code>true</code> to skip the possible vetoing conditions
   * like event firing.
   * @param doFocus Pass <code>true</code> to immediately focus the active editor.
   * @return <code>true</code> if this cell is actionable (editable)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.CellEditing.html#method-activateCell Original Ext JS documentation of 'activateCell'
   */
  protected native function activateCell(position:CellContext, skipBeforeCheck:Boolean = false, doFocus:Boolean = false):Boolean;

  /**
   * Cancels any active editing.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.CellEditing.html#method-cancelEdit Original Ext JS documentation of 'cancelEdit'
   */
  override public native function cancelEdit():void;

  /**
   * Cancels the currently focused operation. In this case CellEditing.
   * the view is being changed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.CellEditing.html#method-deactivate Original Ext JS documentation of 'deactivate'
   */
  protected native function deactivate():void;

  /**
   * Called by TableView#resumeActionableMode to resume actionable processing after
   * the view has been changed.
   * @param position The position at which to resume actionable processing.
   * @return <code>true</code> if this Actionable has successfully resumed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.CellEditing.html#method-resume Original Ext JS documentation of 'resume'
   */
  protected native function resume(position:CellContext):Boolean;

  [Deprecated(replacement="setActionableMode", since="5.5.0")]
  /**
   * @param record The Store data record which backs the row to be edited,
   * or index of the record.
   * @param columnHeader The Column object defining the column
   * to be edited, or index of the column.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.CellEditing.html#method-startEdit Original Ext JS documentation of 'startEdit'
   */
  public native function startEdit(record:*, columnHeader:*):void;

  /**
   * Starts editing by position (row/column)
   * @param position A position with keys of row and column.
   * Example usage:
   * <pre>
   * cellEditing.startEditByPosition({
   *     row: 3,
   *     column: 2
   * });
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.CellEditing.html#method-startEditByPosition Original Ext JS documentation of 'startEditByPosition'
   */
  public native function startEditByPosition(position:Object):void;

  /**
   * Called by TableView#suspendActionableMode to suspend actionable processing while
   * the view is being changed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.CellEditing.html#method-suspend Original Ext JS documentation of 'suspend'
   */
  protected native function suspend():void;
}
}