package ext.grid.plugin {
import ext.plugin.AbstractClipboardPlugin;

[Native("Ext.grid.plugin.Clipboard", require)]
/**
 * This <i>grid</i> (→<code>ext.grid.GridPanel</code>) plugin adds clipboard support to a grid.
 * <p><i>Note that the grid must use the
 * spreadsheet selection model (→<code>ext.grid.selection.SpreadsheetModelSelection</code>)
 * to utilize this plugin.</i></p>
 * <p>This class supports the following <code>→ext.plugin.AbstractClipboardPlugin.formats</code>
 * for grid data:</p>
 * <ul>
 * <li><code>cell</code> - Complete field data that can be matched to other grids using the same
 * <i>model</i> (→<code>ext.data.Model</code>) regardless of column order.</li>
 * <li><code>text</code> - Cell content stripped of HTML tags.</li>
 * <li><code>html</code> - Complete cell content, including any rendered HTML tags.</li>
 * <li><code>raw</code> - Underlying field values based on <code>dataIndex</code>.</li>
 * </ul>
 * <p>The <code>cell</code> format is not valid for the <code>→ext.plugin.AbstractClipboardPlugin.system</code>
 * clipboard format.</p>
 * @see ext.grid.GridPanel
 * @see ext.grid.selection.SpreadsheetModelSelection
 * @see ext.plugin.AbstractClipboardPlugin#formats
 * @see ext.data.Model
 * @see ext.plugin.AbstractClipboardPlugin#system
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.Clipboard.html Original Ext JS documentation of 'Ext.grid.plugin.Clipboard'
 */
public class GridClipboardPlugin extends AbstractClipboardPlugin {
  /**
   * @param config @inheritDoc
   */
  public function GridClipboardPlugin(config:GridClipboardPlugin = null) {
    super();
  }
}
}