package ext.grid.plugin {
import ext.Base;
import ext.mixin.IObservable;
import ext.plugin.AbstractPlugin;

[Native("Ext.grid.plugin.Editing", require)]
/**
 * @see ext.grid.plugin.events.GridEditingPlugin_contextEvent.BEFORE_EDIT
 * @eventType ext.grid.plugin.events.GridEditingPlugin_contextEvent.BEFORE_EDIT
 */
[Event(name='onBeforeEdit', type='ext.grid.plugin.events.GridEditingPlugin_contextEvent')]
/**
 * @see ext.grid.plugin.events.GridEditingPlugin_contextEvent.CANCEL_EDIT
 * @eventType ext.grid.plugin.events.GridEditingPlugin_contextEvent.CANCEL_EDIT
 */
[Event(name='onCancelEdit', type='ext.grid.plugin.events.GridEditingPlugin_contextEvent')]
/**
 * @see ext.grid.plugin.events.GridEditingPlugin_contextEvent.EDIT
 * @eventType ext.grid.plugin.events.GridEditingPlugin_contextEvent.EDIT
 */
[Event(name='onEdit', type='ext.grid.plugin.events.GridEditingPlugin_contextEvent')]
/**
 * @see ext.grid.plugin.events.GridEditingPlugin_contextEvent.VALIDATE_EDIT
 * @eventType ext.grid.plugin.events.GridEditingPlugin_contextEvent.VALIDATE_EDIT
 */
[Event(name='onValidateEdit', type='ext.grid.plugin.events.GridEditingPlugin_contextEvent')]
/**
 * This class provides an abstract grid editing plugin on selected
 * <i>columns</i> (→<code>ext.grid.column.Column</code>). The editable columns are specified by providing an
 * →<code>ext.grid.column.Column.editor</code> in the
 * <i>column configuration</i> (→<code>ext.grid.column.Column</code>).
 * <p><b>Note:</b> This class should not be used directly. See →<code>ext.grid.plugin.CellEditingPlugin</code> and
 * →<code>ext.grid.plugin.RowEditingPlugin</code>.</p>
 * @see ext.grid.column.Column
 * @see ext.grid.column.Column#editor
 * @see ext.grid.plugin.CellEditingPlugin
 * @see ext.grid.plugin.RowEditingPlugin
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.Editing.html Original Ext JS documentation of 'Ext.grid.plugin.Editing'
 */
public class GridEditingPlugin extends AbstractPlugin implements IObservable {
  /**
   * @param config @inheritDoc
   */
  public function GridEditingPlugin(config:GridEditingPlugin = null) {
    super();
  }

  [ExtConfig]
  /**
   * The number of clicks on a grid required to display the editor.
   * The only accepted values are <b>1</b> and <b>2</b>.
   * @default 2
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.Editing.html#cfg-clicksToEdit Original Ext JS documentation of 'clicksToEdit'
   */
  public native function get clicksToEdit():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set clicksToEdit(value:Number):void;

  [ExtConfig("default")]
  /**
   * UI for editor fields
   * @default 'default'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.Editing.html#cfg-default Original Ext JS documentation of 'default'
   */
  public native function get default_():String;

  [ExtConfig("default")]
  /**
   * @private
   */
  public native function set default_(value:String):void;

  /**
   * Set to <code>true</code> while the editing plugin is active and an Editor is visible.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.Editing.html#property-editing Original Ext JS documentation of 'editing'
   */
  public native function get editing():Boolean;

  /**
   * @private
   */
  public native function set editing(value:Boolean):void;

  /**
   * @inheritDoc
   */
  public native function get events():Object;

  /**
   * @inheritDoc
   */
  public native function get hasListeners():Object;

  /**
   * @inheritDoc
   */
  public native function get isObservable():Boolean;

  /**
   * @inheritDoc
   */
  public native function set isObservable(value:Boolean):void;

  [ExtConfig]
  /**
   * A config object containing one or more event handlers to be added to this object during
   * initialization. This should be a valid listeners config object as specified in the
   * →<code>ext.util.Observable.addListener()</code> example for attaching
   * multiple handlers at once.
   * <p><b>DOM events from Ext JS <i>Components</i> (→<code>ext.Component</code>)</b></p>
   * <p>While <i>some</i> Ext JS Component classes export selected DOM events (e.g. "click",
   * "mouseover" etc), this is usually only done when extra value can be added. For example
   * the →<code>ext.view.DataView</code>'s <b><code>→ext.view.DataView.event:onItemClick</code></b>
   * event passing the node clicked on. To access DOM events directly from a child element
   * of a Component, we need to specify the <code>element</code> option to identify the Component
   * property to add a DOM listener to:</p>
   * <pre>
   * new Ext.panel.Panel({
   *     width: 400,
   *     height: 200,
   *     dockedItems: [{
   *         xtype: 'toolbar'
   *     }],
   *     listeners: {
   *         click: {
   *             element: 'el', //bind to the underlying el property on the panel
   *             fn: function(){ console.log('click el'); }
   *         },
   *         dblclick: {
   *             element: 'body', //bind to the underlying body property on the panel
   *             fn: function(){ console.log('dblclick body'); }
   *         }
   *     }
   * });
   * </pre>
   * @see ext.util.Observable#addListener()
   * @see ext.Component
   * @see ext.view.DataView
   * @see ext.view.DataView#event:onItemClick
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Observable.html#cfg-listeners Original Ext JS documentation of 'listeners'
   * @see #setListeners()
   */
  public native function get listeners():Object;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set listeners(value:Object):void;

  [ExtConfig]
  /**
   * The event which triggers editing. Supersedes the →<code>clicksToEdit</code> configuration.
   * May be one of:
   * <ul>
   * <li>cellclick</li>
   * <li>celldblclick</li>
   * <li>cellfocus</li>
   * <li>rowfocus</li>
   * </ul>
   * @default undefined
   * @see #clicksToEdit
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.Editing.html#cfg-triggerEvent Original Ext JS documentation of 'triggerEvent'
   */
  public native function get triggerEvent():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set triggerEvent(value:String):void;

  /**
   * @inheritDoc
   */
  public native function addAfterListener():void;

  /**
   * @inheritDoc
   */
  public native function addBeforeListener():void;

  /**
   * @inheritDoc
   */
  public native function addEventListener(type:String, listener:Function, options:Object = null):void;

  /**
   * @inheritDoc
   */
  [Return("this")]
  public native function addListener(eventName:String, fn:Function, scope:Object = null, options:Object = null, order:String = 'current'):Base;

  /**
   * @inheritDoc
   */
  public native function addManagedListener(item:*, ename:*, fn:* = undefined, scope:Object = null, options:Object = null):Object;

  /**
   * Cancels any active edit that is in progress.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.Editing.html#method-cancelEdit Original Ext JS documentation of 'cancelEdit'
   */
  public native function cancelEdit():void;

  /**
   * @inheritDoc
   */
  public native function clearListeners():void;

  /**
   * @inheritDoc
   */
  public native function clearManagedListeners():void;

  /**
   * Completes the edit if there is an active edit in progress.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.Editing.html#method-completeEdit Original Ext JS documentation of 'completeEdit'
   */
  public native function completeEdit():void;

  /**
   * @inheritDoc
   */
  public native function enableBubble(eventNames:*):void;

  /**
   * @inheritDoc
   */
  public native function fireAction(eventName:String, args:Array, fn:Function, scope:Object = null, options:Object = null, order:String = 'before'):void;

  /**
   * @inheritDoc
   */
  public native function fireEvent(eventName:String, ...args):Boolean;

  /**
   * @inheritDoc
   */
  public native function fireEventArgs(eventName:String, args:Array):Boolean;

  /**
   * @inheritDoc
   */
  public native function fireEventedAction(eventName:String, args:Array, fn:*, scope:Object = null, fnArgs:* = undefined):Boolean;

  /** @inheritDoc */
  override public native function getId():String;

  /**
   * @inheritDoc
   */
  public native function hasListener(eventName:String):Boolean;

  /**
   * @inheritDoc
   */
  public native function isSuspended(event:String = null):Boolean;

  /**
   * @inheritDoc
   */
  public native function mon(item:*, ename:*, fn:* = undefined, scope:Object = null, options:Object = null):Object;

  /**
   * @inheritDoc
   */
  public native function mun(item:*, ename:*, fn:Function = null, scope:Object = null):void;

  /**
   * @inheritDoc
   */
  [Return("this")]
  public native function on(eventName:String, fn:Function, scope:Object = null, options:Object = null, order:String = 'current'):Base;

  /**
   * @inheritDoc
   */
  public native function onAfter(eventName:String, fn:Function, scope:Object = null, options:Object = null):void;

  /**
   * @inheritDoc
   */
  public native function onBefore(eventName:String, fn:Function, scope:Object = null, options:Object = null):void;

  /**
   * Fires after the grid is reconfigured
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.Editing.html#method-onReconfigure Original Ext JS documentation of 'onReconfigure'
   */
  protected native function onReconfigure():void;

  /**
   * @inheritDoc
   */
  public native function relayEvents(origin:Object, events:*, prefix:String = null):Object;

  /**
   * @inheritDoc
   */
  public native function removeAfterListener():void;

  /**
   * @inheritDoc
   */
  public native function removeBeforeListener():void;

  /**
   * @inheritDoc
   */
  [Return("this")]
  public native function removeListener(eventName:String, fn:Function, scope:Object = null):void;

  /**
   * @inheritDoc
   */
  public native function removeManagedListener(item:*, ename:*, fn:Function = null, scope:Object = null):void;

  /**
   * Gets the default scope for firing late bound events (string names with
   * no scope attached) at runtime.
   * @param defaultScope (Default this) The default scope to return if none is found.
   * @default this
   * @return The default event scope
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Observable.html#method-resolveListenerScope Original Ext JS documentation of 'resolveListenerScope'
   */
  protected native function resolveListenerScope(defaultScope:Object = null):Object;

  /**
   * @inheritDoc
   */
  public native function resumeEvent(...eventName):void;

  /**
   * @inheritDoc
   */
  public native function resumeEvents(discardQueue:Boolean = false):void;

  /**
   * @inheritDoc
   */
  public native function setListeners(listeners:Object):void;

  /**
   * @inheritDoc
   */
  public native function suspendEvent(...eventName):void;

  /**
   * @inheritDoc
   */
  public native function suspendEvents(queueSuspended:Boolean):void;

  /**
   * @inheritDoc
   */
  [Return("this")]
  public native function un(eventName:String, fn:Function, scope:Object = null):*;

  /**
   * @inheritDoc
   */
  public native function unAfter(eventName:*, fn:*, scope:Object = null, options:Object = null):void;

  /**
   * @inheritDoc
   */
  public native function unBefore(eventName:*, fn:*, scope:Object = null, options:Object = null):void;
}
}