package ext.grid.plugin {
import ext.plugin.AbstractPlugin;

[Native("Ext.grid.plugin.HeaderResizer", require)]
/**
 * Plugin to add header resizing functionality to a HeaderContainer.
 * Always resizing header to the left of the splitter you are resizing.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.HeaderResizer.html Original Ext JS documentation of 'Ext.grid.plugin.HeaderResizer'
 */
public class GridHeaderResizerPlugin extends AbstractPlugin {
  /**
   * @param config @inheritDoc
   */
  public function GridHeaderResizerPlugin(config:GridHeaderResizerPlugin = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * True to resize on the fly rather than using a proxy marker.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.HeaderResizer.html#cfg-dynamic Original Ext JS documentation of 'dynamic'
   * @see #getDynamic()
   * @see #setDynamic()
   */
  public native function get dynamic():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set dynamic(value:Boolean):void;

  /**
   * Returns the value of <code>dynamic</code>.
   * @see #dynamic
   */
  public native function getDynamic():Boolean;

  /**
   * Sets the value of <code>dynamic</code>.
   * @param dynamic The new value.
   * @see #dynamic
   */
  public native function setDynamic(dynamic:Boolean):void;
}
}