package ext.grid.plugin {
import ext.grid.ViewDropZone;
import ext.plugin.AbstractPlugin;
import ext.view.ViewDragZone;

[Native("Ext.grid.plugin.DragDrop", require)]
/**
 * @see ext.grid.plugin.events.GridViewDragDropPlugin_node_data_overModel_dropPosition_dropHandlersEvent.BEFORE_DROP
 * @eventType ext.grid.plugin.events.GridViewDragDropPlugin_node_data_overModel_dropPosition_dropHandlersEvent.BEFORE_DROP
 */
[Event(name='onBeforeDrop', type='ext.grid.plugin.events.GridViewDragDropPlugin_node_data_overModel_dropPosition_dropHandlersEvent')]
/**
 * @see ext.grid.plugin.events.GridViewDragDropPlugin_node_data_overModel_dropPositionEvent.DROP
 * @eventType ext.grid.plugin.events.GridViewDragDropPlugin_node_data_overModel_dropPositionEvent.DROP
 */
[Event(name='onDrop', type='ext.grid.plugin.events.GridViewDragDropPlugin_node_data_overModel_dropPositionEvent')]
/**
 * This plugin provides drag and drop functionality for a <i>GridView</i> (→<code>ext.view.TableView</code>).
 * <p>A specialized instance of →<code>ext.dd.DragZone</code> and →<code>ext.dd.DropZone</code> are attached to the grid view. The DropZone will participate in drops
 * from DragZones having the same →<code>ddGroup</code> including drops from within the same
 * grid.</p>
 * <p>Note that where touch gestures are available, the <code>longpress</code> gesture will initiate
 * the drag in order that the <code>touchstart</code> may still be used to initiate a scroll.</p>
 * <p>On platforms which implement the <a href="https://www.w3.org/TR/pointerevents/">Pointer Events standard</a>
 * (IE), the <code>touchstart</code> event is usually claimed by the platform, however, this plugin
 * uses the <code>longpress</code> event to trigger drags, so <code>touchstart</code> will not initiate a scroll.
 * On these platforms, a two finger drag gesture will scroll the content, or a single
 * finger drag on an empty area of the view will scroll the content.</p>
 * <p>During the drop operation a data object is passed to a participating DropZone's drop
 * handlers. The drag data object has the following properties:</p>
 * <ul>
 * <li>
 * <p><b>copy:</b> →<code>Boolean</code> <br> The value of →<code>copy</code>. Or <code>true</code> if
 * →<code>allowCopy</code> is true <b>and</b> the control key was pressed as the drag operation
 * began.</p>
 * </li>
 * <li>
 * <p><b>view:</b> <i>GridView</i> (→<code>ext.view.TableView</code>) <br> The source grid view from which the
 * drag originated</p>
 * </li>
 * <li>
 * <p><b>ddel:</b> HTMLElement <br> The drag proxy element which moves with the cursor</p>
 * </li>
 * <li>
 * <p><b>item:</b> HTMLElement <br> The grid view node upon which the mousedown event was
 * registered</p>
 * </li>
 * <li>
 * <p><b>records:</b> →<code>Array</code> <br> An Array of →<code>ext.data.Model</code>s
 * representing the selected data being dragged from the source grid view</p>
 * </li>
 * </ul>
 * <p>By adding this plugin to a view, two new events will be fired from the client
 * grid view as well as its owning Grid: <code>→event:onBeforeDrop</code> and <code>→event:onDrop</code>.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var store = Ext.create('Ext.data.Store', {
 *     fields: ['name'],
 *     data: [
 *         ["Lisa"],
 *         ["Bart"],
 *         ["Homer"],
 *         ["Marge"]
 *     ],
 *     proxy: {
 *         type: 'memory',
 *         reader: 'array'
 *     }
 * });
 *
 * Ext.create('Ext.grid.Panel', {
 *     store: store,
 *     enableLocking: true,
 *     columns: [{
 *         header: 'Name',
 *         dataIndex: 'name',
 *         flex: true
 *     }],
 *     viewConfig: {
 *         plugins: {
 *             gridviewdragdrop: {
 *                 dragText: 'Drag and drop to reorganize'
 *             }
 *         }
 *     },
 *     height: 200,
 *     width: 400,
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * @see ext.view.TableView
 * @see ext.dd.DragZone
 * @see ext.dd.DropZone
 * @see #ddGroup
 * @see Boolean
 * @see #copy
 * @see #allowCopy
 * @see Array
 * @see ext.data.Model
 * @see #event:onBeforeDrop
 * @see #event:onDrop
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.DragDrop.html Original Ext JS documentation of 'Ext.grid.plugin.DragDrop'
 */
public class GridViewDragDropPlugin extends AbstractPlugin {
  /**
   * @param config @inheritDoc
   */
  public function GridViewDragDropPlugin(config:GridViewDragDropPlugin = null) {
    super();
  }

  [ExtConfig]
  /**
   * Set as <code>true</code> to allow the user to hold down the control key at the start of the
   * drag operation and copy the dragged records between grids. Otherwise, dragged
   * records will be moved.
   * <p><b>Note:</b> This only applies to records dragged between two different grids with
   * unique stores.</p>
   * <p>See →<code>copy</code> to enable the copying of all dragged records.</p>
   * @default false
   * @see #copy
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.DragDrop.html#cfg-allowCopy Original Ext JS documentation of 'allowCopy'
   */
  public native function get allowCopy():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set allowCopy(value:Boolean):void;

  [ExtConfig]
  /**
   * <code>true</code> to register this container with the Scrollmanager for auto scrolling during drag
   * operations. A →<code>ext.dd.ScrollManager</code> configuration may also be passed.
   * @default false
   * @see ext.dd.#ScrollManager ext.dd.ScrollManager
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.DragDrop.html#cfg-containerScroll Original Ext JS documentation of 'containerScroll'
   */
  public native function get containerScroll():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set containerScroll(value:*):void;

  [ExtConfig]
  /**
   * Set as <code>true</code> to copy the records from the source grid to the destination drop
   * grid. Otherwise, dragged records will be moved.
   * <p><b>Note:</b> This only applies to records dragged between two different grids with
   * unique stores.</p>
   * <p>See →<code>allowCopy</code> to allow only control-drag operations to copy records.</p>
   * @default false
   * @see #allowCopy
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.DragDrop.html#cfg-copy Original Ext JS documentation of 'copy'
   */
  public native function get copy():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set copy(value:Boolean):void;

  [ExtConfig]
  /**
   * A named drag drop group to which this object belongs. If a group is specified, then both
   * the DragZones and DropZone used by this plugin will only interact with other drag drop
   * objects in the same group.
   * @default gridDD
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.DragDrop.html#cfg-ddGroup Original Ext JS documentation of 'ddGroup'
   */
  public native function get ddGroup():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ddGroup(value:String):void;

  [ExtConfig]
  /**
   * The →<code>ddGroup</code> to which the DragZone will belong.
   * <p>This defines which other DropZones the DragZone will interact with. Drag/DropZones
   * only interact with other Drag/DropZones which are members of the same →<code>ddGroup</code>.</p>
   * @see #ddGroup
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.DragDrop.html#cfg-dragGroup Original Ext JS documentation of 'dragGroup'
   */
  public native function get dragGroup():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dragGroup(value:String):void;

  [ExtConfig]
  /**
   * The text to show while dragging.
   * <p>Two placeholders can be used in the text:</p>
   * <ul>
   * <li><code>{0}</code> The number of selected items.</li>
   * <li><code>{1}</code> 's' when more than 1 items (only useful for English).</li>
   * </ul>
   * @default '{0} selected row{1}'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.DragDrop.html#cfg-dragText Original Ext JS documentation of 'dragText'
   */
  public native function get dragText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dragText(value:String):void;

  [ExtConfig]
  /**
   * An →<code>ext.view.ViewDragZone</code> which handles mousedown and dragging of records
   * from the grid.
   * @see ext.view.ViewDragZone
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.DragDrop.html#property-dragZone Original Ext JS documentation of 'dragZone'
   */
  public native function get dragZone():ViewDragZone;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dragZone(value:ViewDragZone):void;

  [ExtConfig]
  /**
   * The →<code>ddGroup</code> to which the DropZone will belong.
   * <p>This defines which other DragZones the DropZone will interact with. Drag/DropZones
   * only interact with other Drag/DropZones which are members of the same →<code>ddGroup</code>.</p>
   * @see #ddGroup
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.DragDrop.html#cfg-dropGroup Original Ext JS documentation of 'dropGroup'
   */
  public native function get dropGroup():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dropGroup(value:String):void;

  [ExtConfig]
  /**
   * An <i>DropZone</i> (→<code>ext.grid.ViewDropZone</code>) which handles mouseover and dropping records
   * in any grid which shares the same →<code>dropGroup</code>.
   * @see ext.grid.ViewDropZone
   * @see #dropGroup
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.DragDrop.html#property-dropZone Original Ext JS documentation of 'dropZone'
   */
  public native function get dropZone():ViewDropZone;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dropZone(value:ViewDropZone):void;

  [ExtConfig]
  /**
   * <code>false</code> to disallow dragging items from the View.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.DragDrop.html#cfg-enableDrag Original Ext JS documentation of 'enableDrag'
   */
  public native function get enableDrag():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableDrag(value:Boolean):void;

  [ExtConfig]
  /**
   * <code>false</code> to disallow the View from accepting drop gestures.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.DragDrop.html#cfg-enableDrop Original Ext JS documentation of 'enableDrop'
   */
  public native function get enableDrop():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableDrop(value:Boolean):void;
}
}