package ext.grid.plugin {
import ext.data.Model;
import ext.grid.CellContext;

[Native("Ext.grid.plugin.RowEditing", require)]
/**
 * The Ext.grid.plugin.RowEditing plugin injects editing at a row level for a Grid. When editing
 * begins, a small floating dialog will be shown for the appropriate row. Each editable column
 * will show a field for editing. There is a button to save or cancel all changes for the edit.
 * <p>The field that will be used for the editor is defined at the
 * →<code>ext.grid.column.Column.editor</code>. The editor can be a field instance or a field
 * configuration. If an editor is not specified for a particular column then that column
 * won't be editable and the value of the column will be displayed. To provide a custom renderer
 * for non-editable values, use the
 * →<code>ext.grid.column.Column.editRenderer</code> configuration on the column.</p>
 * <p>The editor may be shared for each column in the grid, or a different one may be specified
 * for each column. An appropriate field type should be chosen to match the data structure
 * that it will be editing. For example, to edit a date, it would be useful to specify
 * →<code>ext.form.field.DateField</code> as the editor.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.data.Store', {
 *     storeId: 'simpsonsStore',
 *     fields:[ 'name', 'email', 'phone'],
 *     data: [
 *         { name: 'Lisa', email: 'lisa&#64;simpsons.com', phone: '555-111-1224' },
 *         { name: 'Bart', email: 'bart&#64;simpsons.com', phone: '555-222-1234' },
 *         { name: 'Homer', email: 'homer&#64;simpsons.com', phone: '555-222-1244' },
 *         { name: 'Marge', email: 'marge&#64;simpsons.com', phone: '555-222-1254' }
 *     ]
 * });
 *
 * Ext.create('Ext.grid.Panel', {
 *     title: 'Simpsons',
 *     store: Ext.data.StoreManager.lookup('simpsonsStore'),
 *     columns: [
 *         {header: 'Name', dataIndex: 'name', editor: 'textfield'},
 *         {header: 'Email', dataIndex: 'email', flex:1,
 *             editor: {
 *                 xtype: 'textfield',
 *                 allowBlank: false
 *             }
 *         },
 *         {header: 'Phone', dataIndex: 'phone'}
 *     ],
 *     selModel: 'rowmodel',
 *     plugins: {
 *         rowediting: {
 *             clicksToEdit: 1
 *         }
 *     },
 *     height: 200,
 *     width: 400,
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * @see ext.grid.column.Column#editor
 * @see ext.grid.column.Column#editRenderer
 * @see ext.form.field.DateField
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.RowEditing.html Original Ext JS documentation of 'Ext.grid.plugin.RowEditing'
 */
public class RowEditingPlugin extends GridEditingPlugin {
  /**
   * @param config @inheritDoc
   */
  public function RowEditingPlugin(config:RowEditingPlugin = null) {
    super();
  }

  [ExtConfig]
  /**
   * <code>true</code> to automatically cancel any pending changes when the row editor begins editing
   * a new row. <code>false</code> to force the user to explicitly cancel the pending changes.
   * Note that this option is mutually exclusive with →<code>autoUpdate</code>.
   * @default true
   * @see #autoUpdate
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.RowEditing.html#cfg-autoCancel Original Ext JS documentation of 'autoCancel'
   */
  public native function get autoCancel():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set autoCancel(value:Boolean):void;

  [ExtConfig]
  /**
   * Set this to <code>true</code> to automatically confirm any pending changes when the row editor
   * begins editing a new row. When <code>false</code>, the user will need to explicitly confirm
   * the pending changes.
   * Note that if this is set to <code>true</code>, →<code>autoCancel</code> will be set to <code>false</code>.
   * @default false
   * @see #autoCancel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.RowEditing.html#cfg-autoUpdate Original Ext JS documentation of 'autoUpdate'
   */
  public native function get autoUpdate():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set autoUpdate(value:Boolean):void;

  [ExtConfig]
  /**
   * The number of clicks to move the row editor to a new row while it is visible and actively
   * editing another row. This will default to the same value as
   * →<code>ext.grid.plugin.GridEditingPlugin.clicksToEdit</code>.
   * @see ext.grid.plugin.GridEditingPlugin#clicksToEdit
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.RowEditing.html#cfg-clicksToMoveEditor Original Ext JS documentation of 'clicksToMoveEditor'
   */
  public native function get clicksToMoveEditor():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set clicksToMoveEditor(value:Number):void;

  [ExtConfig]
  /**
   * True to show a <i>tooltip</i> (→<code>ext.tip.ToolTip</code>) that summarizes all validation errors present
   * in the row editor. Set to false to prevent the tooltip from showing.
   * @default true
   * @see ext.tip.ToolTip
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.RowEditing.html#cfg-errorSummary Original Ext JS documentation of 'errorSummary'
   */
  public native function get errorSummary():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set errorSummary(value:Boolean):void;

  [ExtConfig]
  /**
   * The ARIA label template for screen readers to announce when row editing starts.
   * This label can be a →<code>ext.StringUtil.format()</code> template, with the only parameter
   * being the row number. Note that row numbers start at base →<code>formAriaLabelRowBase</code>.
   * @default "'Editing row {0}'"
   * @see ext.SStringUtil#format() ext.StringUtil.format()
   * @see #formAriaLabelRowBase
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.RowEditing.html#cfg-formAriaLabel Original Ext JS documentation of 'formAriaLabel'
   */
  public native function get formAriaLabel():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set formAriaLabel(value:String):void;

  [ExtConfig]
  /**
   * Screen readers will announce grid column header as first row of the ARIA table,
   * so the first actual data row is #2 for screen reader users. If your grid has
   * more than one column header row, you might want to increase this number.
   * If the column header is not visible, the base will be decreased automatically.
   * @default 2
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.RowEditing.html#cfg-formAriaLabelRowBase Original Ext JS documentation of 'formAriaLabelRowBase'
   */
  public native function get formAriaLabelRowBase():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set formAriaLabelRowBase(value:Number):void;

  [ExtConfig]
  /**
   * If configured as <code>true</code>, then canceling an edit on a newly inserted
   * record which has not been modified will delete that record from the store.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.RowEditing.html#cfg-removeUnmodified Original Ext JS documentation of 'removeUnmodified'
   */
  public native function get removeUnmodified():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set removeUnmodified(value:Boolean):void;

  /**
   * This method is called when actionable mode is requested for a cell.
   * @param pos The position at which actionable mode was requested.
   * @return <code>false</code> Actionable mode is <i>not</i> entered for RowEditing.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.RowEditing.html#method-activateCell Original Ext JS documentation of 'activateCell'
   */
  protected native function activateCell(pos:CellContext):Boolean;

  /**
   * Called by TableView#resumeActionableMode to resume actionable processing after
   * the view has been changed.
   * @param position The position at which to resume actionable processing.
   * @return <code>true</code> if this Actionable has successfully resumed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.RowEditing.html#method-resume Original Ext JS documentation of 'resume'
   */
  protected native function resume(position:CellContext):Boolean;

  /**
   * Starts editing the specified record, using the specified Column definition to define
   * which field is being edited.
   * @param record The Store data record which backs the row to be edited.
   * @param columnHeader The Column object defining
   * the column field to be focused, or index of the column. If not specified, it will default
   * to the first visible column.
   * @return <code>true</code> if editing was started, <code>false</code> otherwise.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.RowEditing.html#method-startEdit Original Ext JS documentation of 'startEdit'
   */
  public native function startEdit(record:Model, columnHeader:* = undefined):Boolean;

  /**
   * Called by TableView#suspendActionableMode to suspend actionable processing while
   * the view is being changed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.RowEditing.html#method-suspend Original Ext JS documentation of 'suspend'
   */
  protected native function suspend():void;
}
}