package ext.grid.plugin {
import ext.XTemplate;
import ext.grid.column.Column;
import ext.plugin.AbstractPlugin;

[Native("Ext.grid.plugin.RowExpander", require)]
/**
 * @see ext.grid.plugin.events.RowExpanderPlugin_rowNode_record_expandRowEvent.COLLAPSE_BODY
 * @eventType ext.grid.plugin.events.RowExpanderPlugin_rowNode_record_expandRowEvent.COLLAPSE_BODY
 */
[Event(name='onCollapseBody', type='ext.grid.plugin.events.RowExpanderPlugin_rowNode_record_expandRowEvent')]
/**
 * @see ext.grid.plugin.events.RowExpanderPlugin_rowNode_record_expandRowEvent.EXPAND_BODY
 * @eventType ext.grid.plugin.events.RowExpanderPlugin_rowNode_record_expandRowEvent.EXPAND_BODY
 */
[Event(name='onExpandBody', type='ext.grid.plugin.events.RowExpanderPlugin_rowNode_record_expandRowEvent')]
/**
 * Plugin (ptype = 'rowexpander') that adds the ability to have a Column in a grid which enables
 * a second row body which expands/contracts. The expand/contract behavior is configurable to react
 * on clicking of the column, double click of the row, and/or hitting enter while a row is selected.
 * <p><b>Note:</b> The <i>rowexpander</i> (→<code>ext.grid.plugin.RowExpanderPlugin</code>) plugin and the rowbody
 * feature are exclusive and cannot both be set on the same grid / tree.</p>
 * @see ext.grid.plugin.RowExpanderPlugin
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.RowExpander.html Original Ext JS documentation of 'Ext.grid.plugin.RowExpander'
 */
public class RowExpanderPlugin extends AbstractPlugin {
  /**
   * @param config @inheritDoc
   */
  public function RowExpanderPlugin(config:RowExpanderPlugin = null) {
    super();
  }

  [ExtConfig]
  /**
   * Configure as <code>true</code> to put the row expander body <i>before</i> the data row.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.RowExpander.html#cfg-bodyBefore Original Ext JS documentation of 'bodyBefore'
   */
  public native function get bodyBefore():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set bodyBefore(value:Boolean):void;

  [ExtConfig]
  /**
   * The width of the row expander column which contains the [+]/[-] icons to toggle
   * row expansion.
   * @default 24
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.RowExpander.html#cfg-columnWidth Original Ext JS documentation of 'columnWidth'
   */
  public native function get columnWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set columnWidth(value:Number):void;

  [ExtConfig]
  /**
   * <code>true</code> to toggle a row between expanded/collapsed when double clicked
   * (defaults to <code>true</code>).
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.RowExpander.html#cfg-expandOnDblClick Original Ext JS documentation of 'expandOnDblClick'
   */
  public native function get expandOnDblClick():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set expandOnDblClick(value:Boolean):void;

  [ExtConfig]
  /**
   * This config is no longer supported. The Enter key initiated the grid's actinoable mode.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.RowExpander.html#cfg-expandOnEnter Original Ext JS documentation of 'expandOnEnter'
   */
  public native function get expandOnEnter():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set expandOnEnter(value:Boolean):void;

  [ExtConfig]
  /**
   * The width of the Row Expander column header
   * @default 24
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.RowExpander.html#cfg-headerWidth Original Ext JS documentation of 'headerWidth'
   */
  public native function get headerWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set headerWidth(value:Number):void;

  [ExtConfig]
  /**
   * An XTemplate which, when passed a record data object, produces HTML for the expanded
   * row content <i>on the locked side of a lockable grid</i>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.RowExpander.html#cfg-lockedTpl Original Ext JS documentation of 'lockedTpl'
   */
  public native function get lockedTpl():XTemplate;

  [ExtConfig]
  /**
   * @private
   */
  public native function set lockedTpl(value:XTemplate):void;

  [ExtConfig]
  /**
   * An XTemplate which, when passed a record data object, produces HTML for the expanded
   * row content.
   * <p>Note that if this plugin is applied to a lockable grid, the rowBodyTpl applies to the normal
   * (unlocked) side. See →<code>lockedTpl</code></p>
   * @see #lockedTpl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.RowExpander.html#cfg-rowBodyTpl Original Ext JS documentation of 'rowBodyTpl'
   */
  public native function get rowBodyTpl():XTemplate;

  [ExtConfig]
  /**
   * @private
   */
  public native function set rowBodyTpl(value:XTemplate):void;

  [ExtConfig]
  /**
   * <code>true</code> to ensure that the full row expander body is visible when clicking on the expander
   * icon (defaults to <code>true</code>)
   * @default true
   * @since 6.2.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.RowExpander.html#cfg-scrollIntoViewOnExpand Original Ext JS documentation of 'scrollIntoViewOnExpand'
   */
  public native function get scrollIntoViewOnExpand():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set scrollIntoViewOnExpand(value:Boolean):void;

  [ExtConfig]
  /**
   * <code>true</code> to select a row when clicking on the expander icon
   * (defaults to <code>false</code>).
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.RowExpander.html#cfg-selectRowOnExpand Original Ext JS documentation of 'selectRowOnExpand'
   */
  public native function get selectRowOnExpand():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set selectRowOnExpand(value:Boolean):void;

  [ArrayElementType("ext.grid.feature.IFeature")]
  /**
   * @return And array of Features or Feature config objects.
   * Returns the array of Feature configurations needed to make the RowExpander work.
   * May be overridden in a subclass to modify the returned array.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.RowExpander.html#method-getFeatureConfig Original Ext JS documentation of 'getFeatureConfig'
   */
  protected native function getFeatureConfig(grid:*):Array;

  protected native function getHeaderConfig():Column;
}
}