package ext.grid.plugin {
import ext.mixin.IIdentifiable;
import ext.mixin.IStyleCacher;

[Native("Ext.grid.plugin.RowWidget", require)]
/**
 * Plugin (ptype = 'rowwidget') that adds the ability to second row body in a grid
 * which expands/contracts.
 * <p>The expand/contract behavior is configurable to react on clicking of the column,
 * double click of the row, and/or hitting enter while a row is selected.</p>
 * <p>The expansion row may contain a →<code>widget</code> which is primed with the record
 * of the corresponding grid row. The widget's
 * →<code>ext.Component.defaultBindProperty</code> property is set to the record.</p>
 * @see #widget
 * @see ext.Component#defaultBindProperty
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.RowWidget.html Original Ext JS documentation of 'Ext.grid.plugin.RowWidget'
 */
public class RowWidgetPlugin extends RowExpanderPlugin implements IIdentifiable, IStyleCacher {
  /**
   * @inheritDoc
   */
  public function RowWidgetPlugin(config:RowWidgetPlugin = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * A map of xtype to →<code>ext.Component.ui</code> names to use when using Components
   * in the expansion row.
   * @default {}
   * @see ext.Component#ui
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.RowWidget.html#cfg-defaultWidgetUI Original Ext JS documentation of 'defaultWidgetUI'
   * @see #getDefaultWidgetUI()
   * @see #setDefaultWidgetUI()
   */
  public native function get defaultWidgetUI():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set defaultWidgetUI(value:Object):void;

  [ExtConfig]
  /**
   * A config object containing an →<code>ext.Component.xtype</code>.
   * <p>This is used to create the widgets or components which are rendered into the expansion row
   * <i>on the locked side of a lockable grid</i>.</p>
   * @see ext.Component#xtype
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.RowWidget.html#cfg-lockedWidget Original Ext JS documentation of 'lockedWidget'
   */
  public native function get lockedWidget():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set lockedWidget(value:Object):void;

  [ExtConfig]
  /**
   * A config object containing an →<code>ext.Component.xtype</code>.
   * <p>This is used to create the widgets or components which are rendered into the expansion row.</p>
   * <p>The associated grid row's record is used to update the widget/component's
   * →<code>ext.Component.defaultBindProperty</code>.</p>
   * <p>Note that if this plugin is applied to a lockable grid, the widget applies to the normal
   * (unlocked) side.
   * See →<code>lockedWidget</code></p>
   * @see ext.Component#xtype
   * @see ext.Component#defaultBindProperty
   * @see #lockedWidget
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.RowWidget.html#cfg-widget Original Ext JS documentation of 'widget'
   */
  public native function get widget():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set widget(value:Object):void;

  /**
   * Returns the value of <code>defaultWidgetUI</code>.
   * @see #defaultWidgetUI
   */
  public native function getDefaultWidgetUI():Object;

  /**
   * @return And array of Features or Feature config objects.
   * Returns the array of Feature configurations needed to make the RowWidget work.
   * May be overridden in a subclass to modify the returned array.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.plugin.RowWidget.html#method-getFeatureConfig Original Ext JS documentation of 'getFeatureConfig'
   */
  override protected native function getFeatureConfig(grid:*):Array;

  /**
   * Sets the value of <code>defaultWidgetUI</code>.
   * @param defaultWidgetUI The new value.
   * @see #defaultWidgetUI
   */
  public native function setDefaultWidgetUI(defaultWidgetUI:Object):void;
}
}