package ext.grid.property {
import ext.data.Model;
import ext.data.Session;

[Native("Ext.grid.property.Property", require)]
/**
 * A specific →<code>ext.data.Model</code> type that represents a name/value pair and is made to work
 * with the →<code>ext.grid.property.PropertyGrid</code>. Typically, Properties do not need to be created
 * directly as they can be created implicitly by simply using the appropriate data configs
 * either via the →<code>ext.grid.property.PropertyGrid.source</code> config property or by calling
 * →<code>ext.grid.property.PropertyGrid.setSource()</code>. However, if the need arises, these records
 * can also be created explicitly as shown below. Example usage:
 * <pre>
 * var rec = new Ext.grid.property.Property({
 *     name: 'birthday',
 *     value: Ext.Date.parse('17/06/1962', 'd/m/Y')
 * });
 * // Add record to an already populated grid
 * grid.store.addSorted(rec);
 * </pre>
 * @see ext.data.Model
 * @see ext.grid.property.PropertyGrid
 * @see ext.grid.property.PropertyGrid#source
 * @see ext.grid.property.PropertyGrid#setSource()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.property.Property.html Original Ext JS documentation of 'Ext.grid.property.Property'
 */
public class Property extends Model {
  /**
   * Creates new property.
   * @param config A data object in the format:
   * <ul>
   * <li><code>name</code> (optional) —
   * A name or names for the property.
   * </li>
   * <li><code>value</code> (optional) —
   * A value or values for the property.
   * The specified value's type will be read automatically by the grid to determine
   * the type of editor to use when displaying it.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.property.Property.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function Property(data:Object, session:Session = null) {
    super(null);
  }
}
}