package ext.grid.property {
import ext.grid.GridPanel;

[Native("Ext.grid.property.Grid", require)]
/**
 * @see ext.grid.property.events.PropertyGrid_source_recordId_value_oldValueEvent.BEFORE_PROPERTY_CHANGE
 * @eventType ext.grid.property.events.PropertyGrid_source_recordId_value_oldValueEvent.BEFORE_PROPERTY_CHANGE
 */
[Event(name='onBeforePropertyChange', type='ext.grid.property.events.PropertyGrid_source_recordId_value_oldValueEvent')]
/**
 * @see ext.grid.property.events.PropertyGrid_source_recordId_value_oldValueEvent.PROPERTY_CHANGE
 * @eventType ext.grid.property.events.PropertyGrid_source_recordId_value_oldValueEvent.PROPERTY_CHANGE
 */
[Event(name='onPropertyChange', type='ext.grid.property.events.PropertyGrid_source_recordId_value_oldValueEvent')]
/**
 * A specialized grid implementation intended to mimic the traditional property grid as
 * typically seen in development IDEs. Each row in the grid represents a property of some object,
 * and the data is stored as a set of name/value pairs in
 * <i>Properties</i> (→<code>ext.grid.property.Property</code>). By default, the editors shown are inferred
 * from the data in the cell. More control over this can be specified by using the
 * →<code>sourceConfig</code> option. Example usage:
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.grid.property.Grid', {
 *     title: 'Properties Grid',
 *     width: 300,
 *     renderTo: Ext.getBody(),
 *     source: {
 *         "(name)": "My Object",
 *         "Created": Ext.Date.parse('10/15/2006', 'm/d/Y'),
 *         "Available": false,
 *         "Version": 0.01,
 *         "Description": "A test object"
 *     }
 * });
 * </pre>
 * @see ext.grid.property.Property
 * @see #sourceConfig
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.property.Grid.html Original Ext JS documentation of 'Ext.grid.property.Grid'
 */
public class PropertyGrid extends GridPanel {
  /**
   * @param config @inheritDoc
   */
  public function PropertyGrid(config:PropertyGrid = null) {
    super();
  }

  [Deprecated(replacement="sourceConfig", since="6.5.0")]
  [ExtConfig]
  /**
   * An object containing name/value pairs of custom editor type definitions that allow
   * the grid to support additional types of editable fields. By default, the grid supports
   * strongly-typed editing of strings, dates, numbers and booleans using built-in form editors,
   * but any custom type can be supported and associated with a custom input control
   * by specifying a custom editor. The name of the editor type should correspond
   * with the name of the property that will use the editor. Example usage:
   * <pre>
   * var grid = new Ext.grid.property.Grid({
   *
   *     // Custom editors for certain property names
   *     customEditors: {
   *         evtStart: Ext.create('Ext.form.TimeField', {selectOnFocus: true})
   *     },
   *
   *     // Displayed name for property names in the source
   *     propertyNames: {
   *         evtStart: 'Start Time'
   *     },
   *
   *     // Data object containing properties to edit
   *     source: {
   *         evtStart: '10:00 AM'
   *     }
   * });
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.property.Grid.html#cfg-customEditors Original Ext JS documentation of 'customEditors'
   */
  public native function get customEditors():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set customEditors(value:Object):void;

  [Deprecated(replacement="sourceConfig", since="6.5.0")]
  [ExtConfig]
  /**
   * An object containing name/value pairs of custom renderer type definitions that allow
   * the grid to support custom rendering of fields. By default, the grid supports strongly-typed
   * rendering of strings, dates, numbers and booleans using built-in form editors,
   * but any custom type can be supported and associated with the type of the value.
   * The name of the renderer type should correspond with the name of the property
   * that it will render. Example usage:
   * <pre>
   * var grid = Ext.create('Ext.grid.property.Grid', {
   *     customRenderers: {
   *         Available: function(v){
   *             if (v) {
   *                 return '&lt;span style="color: green;"&gt;Yes&lt;/span&gt;';
   *             } else {
   *                 return '&lt;span style="color: red;"&gt;No&lt;/span&gt;';
   *             }
   *         }
   *     },
   *     source: {
   *         Available: true
   *     }
   * });
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.property.Grid.html#cfg-customRenderers Original Ext JS documentation of 'customRenderers'
   */
  public native function get customRenderers():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set customRenderers(value:Object):void;

  [ExtConfig]
  /**
   * True to automatically infer the <i>type</i> (→<code>sourceConfig</code>) based on the initial value passed
   * for each field. This ensures the editor remains the correct type even if the value is blanked
   * and becomes empty.
   * @default true
   * @see #sourceConfig
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.property.Grid.html#cfg-inferTypes Original Ext JS documentation of 'inferTypes'
   */
  public native function get inferTypes():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set inferTypes(value:Boolean):void;

  [ExtConfig]
  /**
   * Specify the width for the name column. The value column will take any remaining space.
   * @default 115
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.property.Grid.html#cfg-nameColumnWidth Original Ext JS documentation of 'nameColumnWidth'
   */
  public native function get nameColumnWidth():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set nameColumnWidth(value:*):void;

  [ExtConfig]
  /**
   * The name of the field from the property store to use as the property field name.
   * This may be useful if you do not configure the property Grid from an object,
   * but use your own store configuration.
   * @default 'name'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.property.Grid.html#cfg-nameField Original Ext JS documentation of 'nameField'
   */
  public native function get nameField():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set nameField(value:String):void;

  [Deprecated(replacement="sourceConfig", since="6.5.0")]
  [ExtConfig]
  /**
   * An object containing custom property name/display name pairs.
   * If specified, the display name will be shown in the name column instead of the property name.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.property.Grid.html#cfg-propertyNames Original Ext JS documentation of 'propertyNames'
   */
  public native function get propertyNames():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set propertyNames(value:Object):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * A data object to use as the data source of the grid (see →<code>setSource()</code> for details).
   * @see #setSource()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.property.Grid.html#cfg-source Original Ext JS documentation of 'source'
   * @see #getSource()
   */
  public native function get source():Object;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set source(value:Object):void;

  [ExtConfig]
  /**
   * This option allows various configurations to be set for each field in the property grid.
   * None of these configurations are required
   * <p><i>displayName</i></p>
   * <p>A custom name to appear as label for this field. If specified, the display name will be shown
   * in the name column instead of the property name. Example usage:</p>
   * <pre>
   * new Ext.grid.property.Grid({
   *     source: {
   *         clientIsAvailable: true
   *     },
   *     sourceConfig: {
   *         clientIsAvailable: {
   *             // Custom name different to the field
   *             displayName: 'Available'
   *         }
   *     }
   * });
   * </pre>
   * <p><i>renderer</i></p>
   * <p>A function used to transform the underlying value before it is displayed in the grid.
   * By default, the grid supports strongly-typed rendering of strings, dates, numbers and
   * booleans using built-in form editors, but any custom type can be supported and associated
   * with the type of the value. Example usage:</p>
   * <pre>
   * new Ext.grid.property.Grid({
   *     source: {
   *         clientIsAvailable: true
   *     },
   *     sourceConfig: {
   *         clientIsAvailable: {
   *             // Custom renderer to change the color based on the value
   *             renderer: function(v){
   *                 var color = v ? 'green' : 'red';
   *                 return '&lt;span style="color: ' + color + ';"&gt;' + v + '&lt;/span&gt;';
   *             }
   *         }
   *     }
   * });
   * </pre>
   * <p><i>type</i></p>
   * <p>Used to explicitly specify the editor type for a particular value. By default, the type is
   * automatically inferred from the value. See →<code>inferTypes</code>. Accepted values are:</p>
   * <ul>
   * <li>'date'</li>
   * <li>'boolean'</li>
   * <li>'number'</li>
   * <li>'string'</li>
   * </ul>
   * <p>For more advanced control an editor configuration can be passed (see the next section).
   * Example usage:</p>
   * <pre>
   * new Ext.grid.property.Grid({
   *     source: {
   *         attending: null
   *     },
   *     sourceConfig: {
   *         attending: {
   *             // Force the type to be a numberfield, a null value would otherwise default
   *             // to a textfield
   *             type: 'number'
   *         }
   *     }
   * });
   * </pre>
   * <p><i>editor</i></p>
   * <p>Allows the grid to support additional types of editable fields. By default, the grid
   * supports strongly-typed editing of strings, dates, numbers and booleans using built-in
   * form editors, but any custom type can be supported and associated with a custom input control
   * by specifying a custom editor. Example usage</p>
   * <pre>
   * new Ext.grid.property.Grid({
   *     // Data object containing properties to edit
   *     source: {
   *         evtStart: '10:00 AM'
   *     },
   *
   *     sourceConfig: {
   *         evtStart: {
   *             editor: Ext.create('Ext.form.field.Time', {selectOnFocus: true}),
   *             displayName: 'Start Time'
   *         }
   *     }
   * });
   * </pre>
   * @see #inferTypes
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.property.Grid.html#cfg-sourceConfig Original Ext JS documentation of 'sourceConfig'
   */
  public native function get sourceConfig():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set sourceConfig(value:Object):void;

  [ExtConfig]
  /**
   * The name of the field from the property store to use as the value field name.
   * This may be useful if you do not configure the property Grid from an object,
   * but use your own store configuration.
   * @default 'value'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.property.Grid.html#cfg-valueField Original Ext JS documentation of 'valueField'
   */
  public native function get valueField():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set valueField(value:String):void;

  /**
   * Gets the value of a property.
   * @since 5.1.1
   * @param prop The name of the property.
   * @return The property value. <code>null</code> if there is no value.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.property.Grid.html#method-getProperty Original Ext JS documentation of 'getProperty'
   */
  public native function getProperty(prop:String):Object;

  /**
   * Gets the source data object containing the property data. See →<code>setSource()</code>
   * for details regarding the format of the data object.
   * @return The data object.
   * @see #setSource()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.property.Grid.html#method-getSource Original Ext JS documentation of 'getSource'
   */
  public native function getSource():Object;

  /**
   * Removes a property from the grid.
   * @param prop The name of the property to remove.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.property.Grid.html#method-removeProperty Original Ext JS documentation of 'removeProperty'
   */
  public native function removeProperty(prop:String):void;

  /**
   * Sets the value of a property.
   * @param prop The name of the property to set.
   * @param value The value to test.
   * @param create <code>true</code> to create the property if it doesn't already exist.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.property.Grid.html#method-setProperty Original Ext JS documentation of 'setProperty'
   */
  public native function setProperty(prop:String, value:*, create:Boolean = false):void;

  /**
   * Sets the source data object containing the property data. The data object can contain
   * one or more name/value pairs representing all of the properties of an object to display
   * in the grid, and this data will automatically be loaded into the grid's →<code>store</code>.
   * The values should be supplied in the proper data type if needed, otherwise string type
   * will be assumed. If the grid already contains data, this method will replace any
   * existing data. See also the →<code>source</code> config value. Example usage:
   * <pre>
   * grid.setSource({
   *     "(name)": "My Object",
   *     "Created": Ext.Date.parse('10/15/2006', 'm/d/Y'),  // date type
   *     "Available": false,  // boolean type
   *     "Version": .01,      // decimal type
   *     "Description": "A test object"
   * });
   * </pre>
   * @param source The data object.
   * @param sourceConfig A new <i>object</i> (→<code>sourceConfig</code>). If this argument
   * is not passed the current configuration will be re-used. To reset the config,
   * pass <code>null</code> or an empty object literal.
   * @see #store
   * @see #source
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.property.Grid.html#method-setSource Original Ext JS documentation of 'setSource'
   * @see #sourceConfig
   */
  public native function setSource(source:Object, sourceConfig:Object = null):void;
}
}