package ext.grid.property {
import ext.grid.header.HeaderContainer;

[Native("Ext.grid.property.HeaderContainer", require)]
/**
 * A custom HeaderContainer for the →<code>ext.grid.property.PropertyGrid</code>.
 * Generally it should not need to be used directly.
 * @see ext.grid.property.PropertyGrid
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.property.HeaderContainer.html Original Ext JS documentation of 'Ext.grid.property.HeaderContainer'
 */
public class PropertyGridHeaderContainer extends HeaderContainer {
  /**
   * Creates new HeaderContainer.
   * @param grid The grid this store will be bound to
   * @param source The source data config object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.property.HeaderContainer.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function PropertyGridHeaderContainer(grid:PropertyGrid, source:Object) {
    super();
  }

  [ExtConfig]
  /**
   * The <i>date format</i> (→<code>ext.DateUtil</code>) to use for date values.
   * @default 'm/j/Y'
   * @see ext.#DateUtil ext.DateUtil
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.property.HeaderContainer.html#cfg-dateFormat Original Ext JS documentation of 'dateFormat'
   */
  public native function get dateFormat():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dateFormat(value:String):void;

  [ExtConfig]
  /**
   * The text to display for boolean <code>false</code> values.
   * @default 'false'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.property.HeaderContainer.html#cfg-falseText Original Ext JS documentation of 'falseText'
   */
  public native function get falseText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set falseText(value:String):void;

  [ExtConfig]
  /**
   * The column header text for the name column.
   * @default 'Name'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.property.HeaderContainer.html#cfg-nameText Original Ext JS documentation of 'nameText'
   */
  public native function get nameText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set nameText(value:String):void;

  [ExtConfig]
  /**
   * The text to display for boolean <code>true</code> values.
   * @default 'true'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.property.HeaderContainer.html#cfg-trueText Original Ext JS documentation of 'trueText'
   */
  public native function get trueText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set trueText(value:String):void;

  [ExtConfig]
  /**
   * The column header text for the value column.
   * @default 'Value'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.property.HeaderContainer.html#cfg-valueText Original Ext JS documentation of 'valueText'
   */
  public native function get valueText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set valueText(value:String):void;
}
}