package ext.grid.property {
import ext.data.Store;
import ext.grid.GridPanel;

[Native("Ext.grid.property.Store", require)]
/**
 * A custom →<code>ext.data.Store</code> for the →<code>ext.grid.property.PropertyGrid</code>. This class handles
 * the mapping between the custom data source objects supported by the grid and the
 * →<code>ext.grid.property.Property</code> format used by the →<code>ext.data.Store</code> base class.
 * @see ext.data.Store
 * @see ext.grid.property.PropertyGrid
 * @see ext.grid.property.Property
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.property.Store.html Original Ext JS documentation of 'Ext.grid.property.Store'
 */
public class PropertyStore extends Store {
  /**
   * Creates new property store.
   * @param grid The grid this store will be bound to
   * @param source The source data config object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.property.Store.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function PropertyStore(grid:GridPanel, source:Object) {
    super();
  }

  /**
   * Should only be called by the grid. Use grid.getSource instead.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.property.Store.html#method-getSource Original Ext JS documentation of 'getSource'
   */
  protected native function getSource():Object;
}
}