package ext.grid.selection {
import ext.grid.CellContext;

[Native("Ext.grid.selection.Cells", require)]
/**
 * A class which encapsulates a range of cells defining a selection in a grid.
 * <p>Note that when range start and end points are represented by an array, the
 * order is traditional <code>x, y</code> order, that is column index followed by row index.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Cells.html Original Ext JS documentation of 'Ext.grid.selection.Cells'
 */
public class CellsSelection extends Selection {
  /**
   * This property indicates the this selection represents selected cells.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Cells.html#property-isCells Original Ext JS documentation of 'isCells'
   */
  public native function get isCells():Boolean;

  /**
   * Returns <code>true</code> if the passed <i>cell context</i> (→<code>ext.grid.CellContext</code>) is selected.
   * @param cellContext The cell context to test.
   * @return <code>true</code> if the passed <i>cell context</i> (→<code>ext.grid.CellContext</code>) is selected.
   * @see ext.grid.CellContext
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Cells.html#method-contains Original Ext JS documentation of 'contains'
   */
  public native function contains(cellContext:CellContext):Boolean;

  /**
   * @return The column index of the first column in the range or zero if no range.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Cells.html#method-getFirstColumnIndex Original Ext JS documentation of 'getFirstColumnIndex'
   */
  public native function getFirstColumnIndex():Number;

  /**
   * @return The row index of the first row in the range or zero if no range.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Cells.html#method-getFirstRowIndex Original Ext JS documentation of 'getFirstRowIndex'
   */
  public native function getFirstRowIndex():Number;

  /**
   * @return The column index of the last column in the range or -1 if no range.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Cells.html#method-getLastColumnIndex Original Ext JS documentation of 'getLastColumnIndex'
   */
  public native function getLastColumnIndex():Number;

  /**
   * @return The row index of the last row in the range or -1 if no range.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Cells.html#method-getLastRowIndex Original Ext JS documentation of 'getLastRowIndex'
   */
  public native function getLastRowIndex():Number;
}
}