package ext.grid.selection {
import ext.grid.column.Column;

[Native("Ext.grid.selection.Columns", require)]
/**
 * A class which encapsulates a range of columns defining a selection in a grid.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Columns.html Original Ext JS documentation of 'Ext.grid.selection.Columns'
 */
public class ColumnsSelection extends Selection {
  /**
   * This property indicates the this selection represents selected columns.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Columns.html#property-isColumns Original Ext JS documentation of 'isColumns'
   */
  public native function get isColumns():Boolean;

  /**
   * Returns <code>true</code> if the passed <i>column</i> (→<code>ext.grid.column.Column</code>) is selected.
   * @param column The column to test.
   * @return <code>true</code> if the passed <i>column</i> (→<code>ext.grid.column.Column</code>) is selected.
   * @see ext.grid.column.Column
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Columns.html#method-contains Original Ext JS documentation of 'contains'
   */
  public native function contains(column:Column):Boolean;

  [ArrayElementType("ext.grid.column.Column")]
  /**
   * Returns the columns selected.
   * @return The columns selected.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Columns.html#method-getColumns Original Ext JS documentation of 'getColumns'
   */
  public native function getColumns():Array;

  /**
   * Returns the number of columns selected.
   * @return The number of columns selected.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Columns.html#method-getCount Original Ext JS documentation of 'getCount'
   */
  public native function getCount():Number;
}
}