package ext.grid.selection {
import ext.data.Model;

[Native("Ext.grid.selection.Rows", require)]
/**
 * A class which encapsulates a range of rows defining a selection in a grid.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Rows.html Original Ext JS documentation of 'Ext.grid.selection.Rows'
 */
public class RowsSelection extends Selection {
  /**
   * This property indicates the this selection represents selected rows.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Rows.html#property-isRows Original Ext JS documentation of 'isRows'
   */
  public native function get isRows():Boolean;

  /**
   * This method is called to indicate the start of multiple changes to the selected row set.
   * <p>Internally this method increments a counter that is decremented by <code>→endUpdate()</code>. It
   * is important, therefore, that if you call <code>→beginUpdate()</code> directly you match that
   * call with a call to <code>→endUpdate()</code> or you will prevent the collection from updating
   * properly.</p>
   * @see #endUpdate()
   * @see #beginUpdate()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Rows.html#method-beginUpdate Original Ext JS documentation of 'beginUpdate'
   */
  public native function beginUpdate():void;

  /**
   * Returns <code>true</code> if the passed <i>record</i> (→<code>ext.data.Model</code>) is selected.
   * @param record The record to test.
   * @return <code>true</code> if the passed <i>record</i> (→<code>ext.data.Model</code>) is selected.
   * @see ext.data.Model
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Rows.html#method-contains Original Ext JS documentation of 'contains'
   */
  public native function contains(record:Model):Boolean;

  /**
   * This method is called after modifications are complete on a selected row set. For details
   * see <code>→beginUpdate()</code>.
   * @see #beginUpdate()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Rows.html#method-endUpdate Original Ext JS documentation of 'endUpdate'
   */
  public native function endUpdate():void;

  /**
   * Returns the number of records selected
   * @return The number of records selected.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Rows.html#method-getCount Original Ext JS documentation of 'getCount'
   */
  public native function getCount():Number;

  /**
   * @return The row index of the first row in the range or zero if no range.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Rows.html#method-getFirstRowIndex Original Ext JS documentation of 'getFirstRowIndex'
   */
  public native function getFirstRowIndex():Number;

  /**
   * @return The row index of the last row in the range or -1 if no range.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Rows.html#method-getLastRowIndex Original Ext JS documentation of 'getLastRowIndex'
   */
  public native function getLastRowIndex():Number;

  [ArrayElementType("ext.data.Model")]
  /**
   * Returns the records selected.
   * @return The records selected.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Rows.html#method-getRecords Original Ext JS documentation of 'getRecords'
   */
  public native function getRecords():Array;
}
}