package ext.grid.selection {
import ext.Base;

[Native("Ext.grid.selection.Selection", require)]
/**
 * Base class for selections which may be of three subtypes...
 * <ul>
 * <li>→<code>ext.grid.selection.CellsSelection</code> A rectangular range of cells defined by a start
 * record/column and an end record/column.</li>
 * <li>→<code>ext.grid.selection.RowsSelection</code> An array of records.</li>
 * <li>→<code>ext.grid.selection.ColumnsSelection</code> An array of columns in which all records
 * are included.</li>
 * </ul>
 * @see ext.grid.selection.CellsSelection
 * @see ext.grid.selection.RowsSelection
 * @see ext.grid.selection.ColumnsSelection
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Selection.html Original Ext JS documentation of 'Ext.grid.selection.Selection'
 */
public class Selection extends Base {
  /**
   * Clones this selection object.
   * @return A clone of this instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Selection.html#method-clone Original Ext JS documentation of 'clone'
   */
  public native function clone():Selection;

  /**
   * Calls the passed function for each selected cell from top left to bottom right
   * iterating over columns within each row.
   * @param fn The function to call. If this returns <code>false</code>, the iteration is
   * halted with no further calls.
   * <ul>
   * <li><code>context:ext.grid.CellContext</code> (optional) —
   * The CellContext representing the current cell.
   * </li>
   * <li><code>columnIndex:Number</code> (optional) —
   * The column index of the current cell.
   * </li>
   * <li><code>rowIndex:Number</code> (optional) —
   * The row index of the current cell.
   * </li>
   * </ul>
   * @param scope The context (<code>this</code> reference) in which <code>fn</code> is executed.
   * Defaults to this Selection object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Selection.html#method-eachCell Original Ext JS documentation of 'eachCell'
   */
  public native function eachCell(fn:Function, scope:Object = null):void;

  /**
   * Calls the passed function for each selected column from left to right.
   * @param fn The function to call. If this returns false, the iteration is
   * halted with no further calls.
   * <ul>
   * <li><code>column:ext.grid.column.Column</code> (optional) —
   * The current column.
   * </li>
   * <li><code>columnIndex:Number</code> (optional) —
   * The index of the current column. <i>Note that in a
   * locked grid, this is relative to the outermost grid encompassing both sides</i>.
   * </li>
   * </ul>
   * @param scope The context (<code>this</code> reference) in which <code>fn</code> is executed.
   * Defaults to this Selection object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Selection.html#method-eachColumn Original Ext JS documentation of 'eachColumn'
   */
  public native function eachColumn(fn:Function, scope:Object = null):void;

  /**
   * Calls the passed function for each selected <i>record</i> (→<code>ext.data.Model</code>).
   * @param fn The function to call. If this returns <code>false</code>, the iteration is
   * halted with no further calls.
   * <ul>
   * <li><code>record:ext.data.Model</code> (optional) —
   * The current record.
   * </li>
   * </ul>
   * @param scope The context (<code>this</code> reference) in which the function is executed.
   * Defaults to this Selection object.
   * @see ext.data.Model
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Selection.html#method-eachRow Original Ext JS documentation of 'eachRow'
   */
  public native function eachRow(fn:Function, scope:Object = null):void;
}
}