package ext.grid.selection {
import ext.data.Model;
import ext.panel.TablePanel;
import ext.plugin.AbstractPlugin;

[Native("Ext.grid.selection.Replicator", require)]
/**
 * A plugin for use in grids which use the <i>spreadsheet</i> (→<code>ext.grid.selection.SpreadsheetModelSelection</code>)
 * selection model, with →<code>ext.grid.selection.SpreadsheetModelSelection.extensible</code>
 * configured as <code>true</code> or <code>"y"</code>, meaning that the selection may be extended up or down
 * using a draggable extension handle.
 * <p>This plugin propagates values from the selection into the extension area.</p>
 * <p>If just <i>one</i> row is selected, the values in that row are replicated unchanged into the extension
 * area.</p>
 * <p>If more than one row is selected, the two rows closest to the selected block are taken to provide
 * a numeric difference, and that difference is used to calculate the sequence of values all the way
 * into the extension area.</p>
 * @see ext.grid.selection.SpreadsheetModelSelection
 * @see ext.grid.selection.SpreadsheetModelSelection#extensible
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Replicator.html Original Ext JS documentation of 'Ext.grid.selection.Replicator'
 */
public class SelectionReplicator extends AbstractPlugin {
  /**
   * @param config @inheritDoc
   */
  public function SelectionReplicator(config:SelectionReplicator = null) {
    super();
  }

  [ArrayElementType("ext.grid.column.Column")]
  /**
   * An array of the columns encompassed by the selection block. This is gathered before
   * →<code>replicateSelection()</code> is called, so is available to subclasses which implement
   * their own →<code>replicateSelection()</code> method.
   * @see #replicateSelection()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Replicator.html#property-columns Original Ext JS documentation of 'columns'
   */
  public native function get columns():Array;

  /**
   * @private
   */
  public native function set columns(value:Array):void;

  /**
   * A utility method, which, when passed a record, uses the →<code>columns</code> property
   * to extract the values of that record which are encompassed by the selection.
   * <p>Note that columns with no →<code>ext.grid.column.Column.dataIndex</code>
   * cannot yield a value.</p>
   * @param record The record from which to read values.
   * @return The values of the fields used by the selected column range
   * for the passed record.
   * @see #columns
   * @see ext.grid.column.Column#dataIndex
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Replicator.html#method-getColumnValues Original Ext JS documentation of 'getColumnValues'
   */
  public native function getColumnValues(record:Model):Array;

  /**
   * This is the method which is called when the
   * <i>spreadsheet</i> (→<code>ext.grid.selection.SpreadsheetModelSelection</code>) selection model's extender handle
   * is dragged and released.
   * <p>It is passed contextual information about the selection and the extension area.</p>
   * <p>Subclass authors may override it to gain access to the event and perform their own
   * data replication.</p>
   * <p>By default, the selection is extended to encompass the selection area.
   * Returning <code>false</code> from this method vetoes that.</p>
   * @param ownerGrid The owning grid.
   * @param sel An object describing the contiguous selected area.
   * @param extension An object describing the type and size of extension.
   * <ul>
   * <li><code>type:String</code> (optional) —
   * <code>"rows"</code> or <code>"columns"</code>
   * </li>
   * <li><code>start:ext.grid.CellContext</code> (optional) —
   * The start (top left) cell of the extension
   * area.
   * </li>
   * <li><code>end:ext.grid.CellContext</code> (optional) —
   * The end (bottom right) cell of the extension
   * area.
   * </li>
   * <li><code>columns:Number</code> (optional) —
   * The number of columns extended (-ve means
   * on the left side).
   * </li>
   * <li><code>rows:Number</code> (optional) —
   * The number of rows extended (-ve means on the top side).
   * </li>
   * </ul>
   * @see ext.grid.selection.SpreadsheetModelSelection
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.Replicator.html#method-replicateSelection Original Ext JS documentation of 'replicateSelection'
   */
  public native function replicateSelection(ownerGrid:TablePanel, sel:Selection, extension:Object):void;
}
}