package ext.grid.selection.events {
import ext.grid.GridPanel;
import ext.grid.selection.Selection;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.grid.selection.events.SpreadsheetModelSelection_grid_selectionEvent")]
public class SpreadsheetModelSelection_grid_selectionEvent extends FlExtEvent {
  /**
   * Fired <i>by the grid</i> after the selection changes. Return <code>false</code> to veto the selection
   * extension.
   * <p>Note that the behavior of selectionchange is different in Ext 6.x vs. Ext 5. In Ext 6.x,
   * if rows are being selected, a block of records is passed as the second parameter.
   * In Ext 5, the selection object was passed.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.selection.SpreadsheetModel.html#event-selectionchange Original Ext JS documentation of 'selectionchange'
   * @see ext.grid.selection.SpreadsheetModelSelection
   * @eventType onSelectionChange
   */
  public static const SELECTION_CHANGE:String = "onSelectionChange";
  public static const __PARAMETER_SEQUENCE__:Array = ["grid", "selection", "eOpts"];

  public function SpreadsheetModelSelection_grid_selectionEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The grid whose selection has changed.
   */
  public native function get grid():GridPanel;

  /**
   * A subclass of
   * →<code>ext.grid.selection.Selection</code> describing the new selection.
   * @see ext.grid.selection.Selection
   */
  public native function get selection():Selection;
}
}