package ext.layout {
import ext.Base;
import ext.Component;
import ext.mixin.IFactoryable;

[Native("Ext.layout.Layout", require)]
[ExtConfig]
/**
 * This class is the base for all layout types: component and container.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.Layout.html Original Ext JS documentation of 'Ext.layout.Layout'
 */
public class Layout extends Base implements IFactoryable {
  /**
   * @param config @inheritDoc
   */
  public function Layout(config:Layout = null) {
    super();
  }

  [ExtConfig]
  /**
   * An object that contains as keys the names of the properties that can be animated
   * by child items as a consequence of a layout. This config is used internally by the
   * <i>accordion</i> (→<code>ext.layout.container.AccordionLayout</code>) layout to cause the child panels
   * to animate to their proper size and position after a collapse/expand event.
   * @since 4.1.0
   * @see ext.layout.container.AccordionLayout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.Layout.html#cfg-animatePolicy Original Ext JS documentation of 'animatePolicy'
   */
  public native function get animatePolicy():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set animatePolicy(value:Object):void;

  /**
   * Used only during a layout run, this value indicates that a
   * layout has finished its calculations. This flag is set to true prior to the call to
   * →<code>calculate()</code> and should be set to false if this layout has more work to do.
   * @see #calculate()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.Layout.html#property-done Original Ext JS documentation of 'done'
   */
  public native function get done():Boolean;

  /**
   * @private
   */
  public native function set done(value:Boolean):void;

  /**
   * @inheritDoc
   */
  public native function get factoryConfig():Object;

  /**
   * @inheritDoc
   */
  public native function set factoryConfig(value:Object):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated Layout, or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.Layout.html#property-isLayout Original Ext JS documentation of 'isLayout'
   */
  public native function get isLayout():Boolean;

  /**
   * Removes layout's itemCls and owning Container's itemCls.
   * Clears the managed dimensions flags
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.Layout.html#method-afterRemove Original Ext JS documentation of 'afterRemove'
   */
  protected native function afterRemove(item:*):void;

  /**
   * Called before any calculation cycles to prepare for layout.
   * <p>This is a write phase and DOM reads should be strictly avoided when overridding
   * this method.</p>
   * @param ownerContext The context item for the layout's owner
   * component.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.Layout.html#method-beginLayout Original Ext JS documentation of 'beginLayout'
   */
  public native function beginLayout(ownerContext:Base):void;

  /**
   * Called before any calculation cycles to reset DOM values and prepare for calculation.
   * <p>This is a write phase and DOM reads should be strictly avoided when overridding
   * this method.</p>
   * @param ownerContext The context item for the layout's owner
   * component.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.Layout.html#method-beginLayoutCycle Original Ext JS documentation of 'beginLayoutCycle'
   */
  public native function beginLayoutCycle(ownerContext:Base):void;

  /**
   * Called to perform the calculations for this layout. This method will be called at
   * least once and may be called repeatedly if the →<code>done</code> property is cleared
   * before return to indicate that this layout is not yet done. The →<code>done</code> property
   * is always set to <code>true</code> before entering this method.
   * <p>This is a read phase and DOM writes should be strictly avoided in derived classes.
   * Instead, DOM writes need to be written to →<code>null</code> objects to
   * be flushed at the next opportunity.</p>
   * @param ownerContext The context item for the layout's owner
   * component.
   * @see #done
   * @see null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.Layout.html#method-calculate Original Ext JS documentation of 'calculate'
   */
  public native function calculate(ownerContext:Base):void;

  /**
   * This method (if implemented) is called at the end of the cycle in which this layout
   * completes (by not setting →<code>done</code> to <code>false</code> in →<code>calculate()</code>). It is
   * possible for the layout to complete and yet become invalid before the end of the cycle,
   * in which case, this method will not be called. It is also possible for this method to
   * be called and then later the layout becomes invalidated. This will result in
   * →<code>calculate()</code> being called again, followed by another call to this method.
   * <p>This is a read phase and DOM writes should be strictly avoided in derived classes.
   * Instead, DOM writes need to be written to →<code>null</code> objects to
   * be flushed at the next opportunity.</p>
   * <p>This method need not be implemented by derived classes and, in fact, should only be
   * implemented when needed.</p>
   * @param ownerContext The context item for the layout's owner
   * component.
   * @see #done
   * @see #calculate()
   * @see null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.Layout.html#method-completeLayout Original Ext JS documentation of 'completeLayout'
   */
  public native function completeLayout(ownerContext:Base):void;

  /**
   * Called before an item is rendered to allow the layout to configure the item.
   * @param item The item to be configured
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.Layout.html#method-configureItem Original Ext JS documentation of 'configureItem'
   */
  protected native function configureItem(item:Component):void;

  /**
   * Destroys this layout. This method removes a <code>targetCls</code> from the <code>target</code>
   * element and calls <code>onDestroy</code>.
   * <p>A derived class can override either this method or <code>onDestroy</code> but in all
   * cases must call the base class versions of these methods to allow the base class to
   * perform its cleanup.</p>
   * <p>This method (or <code>onDestroy</code>) are overridden by subclasses most often to purge
   * event handlers or remove unmanged DOM nodes.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.Layout.html#method-destroy Original Ext JS documentation of 'destroy'
   */
  override public native function destroy(...params):void;

  /**
   * This method (if implemented) is called after all layouts have completed. In most
   * ways this is similar to →<code>completeLayout()</code>. This call can cause this (or any
   * layout) to be become invalid (see →<code>null.invalidate()</code>), but this
   * is best avoided. This method is intended to be where final reads are made and so it
   * is best to avoid invalidating layouts at this point whenever possible. Even so, this
   * method can be used to perform final checks that may require all other layouts to be
   * complete and then invalidate some results.
   * <p>This is a read phase and DOM writes should be strictly avoided in derived classes.
   * Instead, DOM writes need to be written to →<code>null</code> objects to
   * be flushed at the next opportunity.</p>
   * <p>This method need not be implemented by derived classes and, in fact, should only be
   * implemented when needed.</p>
   * @param ownerContext The context item for the layout's owner
   * component.
   * @see #completeLayout()
   * @see null#invalidate()
   * @see null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.Layout.html#method-finalizeLayout Original Ext JS documentation of 'finalizeLayout'
   */
  public native function finalizeLayout(ownerContext:Base):void;

  /**
   * This method is called after all layouts are complete and their calculations flushed
   * to the DOM. No further layouts will be run and this method is only called once per
   * layout run. The base component layout caches <code>lastComponentSize</code>.
   * <p>This is a write phase and DOM reads should be avoided if possible when overridding
   * this method.</p>
   * <p>This method need not be implemented by derived classes and, in fact, should only be
   * implemented when needed.</p>
   * @param ownerContext The context item for the layout's owner
   * component.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.Layout.html#method-finishedLayout Original Ext JS documentation of 'finishedLayout'
   */
  public native function finishedLayout(ownerContext:Base):void;

  /**
   * Returns an object describing how this layout manages the size of the given component.
   * This method must be implemented by any layout that manages components.
   * @return An object describing the sizing done by the layout
   * for this item.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.Layout.html#method-getItemSizePolicy Original Ext JS documentation of 'getItemSizePolicy'
   */
  protected native function getItemSizePolicy(item:Component):SizePolicy;

  [ArrayElementType("ext.Component")]
  /**
   * Returns the set of items to layout (empty by default).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.Layout.html#method-getLayoutItems Original Ext JS documentation of 'getLayoutItems'
   */
  protected native function getLayoutItems():Array;

  /**
   * A one-time initialization method called just before rendering.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.Layout.html#method-initLayout Original Ext JS documentation of 'initLayout'
   */
  protected native function initLayout():void;

  /**
   * Validates item is in the proper place in the dom.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.Layout.html#method-isValidParent Original Ext JS documentation of 'isValidParent'
   */
  protected native function isValidParent(item:*, target:*, position:*):Boolean;

  /**
   * This method (if implemented) is called after all layouts are finished, and all have
   * a <code>lastComponentSize</code> cached. No further layouts will be run and this method is only
   * called once per layout run. It is the bookend to →<code>beginLayout()</code>.
   * <p>This is a write phase and DOM reads should be avoided if possible when overridding
   * this method. This is the catch-all tail method to a layout and so the rules are more
   * relaxed. Even so, for performance reasons, it is best to avoid reading the DOM. If
   * a read is necessary, consider implementing a →<code>finalizeLayout()</code> method to do the
   * required reads.</p>
   * <p>This method need not be implemented by derived classes and, in fact, should only be
   * implemented when needed.</p>
   * @param ownerContext The context item for the layout's owner
   * component.
   * @see #beginLayout()
   * @see #finalizeLayout()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.Layout.html#method-notifyOwner Original Ext JS documentation of 'notifyOwner'
   */
  public native function notifyOwner(ownerContext:Base):void;

  /**
   * This method is called when a child item changes in some way. By default this calls
   * →<code>ext.Component.updateLayout()</code> on this layout's owner.
   * @param child The child item that has changed.
   * @return True if this layout has handled the content change.
   * @see ext.Component#updateLayout()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.Layout.html#method-onContentChange Original Ext JS documentation of 'onContentChange'
   */
  public native function onContentChange(child:Component):Boolean;

  /**
   * Iterates over all passed items, ensuring they are rendered. If the items
   * are already rendered, also determines if the items are in the proper place in the dom.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.Layout.html#method-renderItems Original Ext JS documentation of 'renderItems'
   */
  protected native function renderItems(items:*, target:*):void;
}
}