package ext.layout {

[Native("Ext.layout.SizePolicy", require)]
/**
 * This class describes how a layout will interact with a component it manages.
 * <p>There are special instances of this class stored as static properties to avoid object
 * instantiation. All instances of this class should be treated as readonly objects.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.SizePolicy.html Original Ext JS documentation of 'Ext.layout.SizePolicy'
 */
public class SizePolicy extends Object {
  /**
   * Indicates that the <code>height</code> of the component is consumed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.SizePolicy.html#property-readsHeight Original Ext JS documentation of 'readsHeight'
   */
  public native function get readsHeight():Boolean;

  /**
   * Indicates that the <code>width</code> of the component is consumed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.SizePolicy.html#property-readsWidth Original Ext JS documentation of 'readsWidth'
   */
  public native function get readsWidth():Boolean;

  /**
   * Indicates that the <code>height</code> of the component will be set (i.e., calculated).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.SizePolicy.html#property-setsHeight Original Ext JS documentation of 'setsHeight'
   */
  public native function get setsHeight():Boolean;

  /**
   * Indicates that the <code>width</code> of the component will be set (i.e., calculated).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.SizePolicy.html#property-setsWidth Original Ext JS documentation of 'setsWidth'
   */
  public native function get setsWidth():Boolean;
}
}