package ext.layout.component {

[Native("Ext.layout.component.Auto", require)]
/**
 * The class is the default component layout for →<code>ext.Component</code> when no explicit
 * <code>→ext.Component.componentLayout</code> is configured.
 * <p>This class uses template methods to perform the individual aspects of measurement,
 * calculation and publication of results. The methods called depend on the component's
 * <i>size model</i> (→<code>ext.Component.getSizeModel()</code>).</p>
 * <p><b><i>configured / calculated</i></b></p>
 * <p>In either of these size models, the dimension of the outer element is of a known size.
 * The size is found in the <code>ownerContext</code> (the →<code>null</code> for the owner
 * component) as either "width" or "height". This value, if available, is passed to the
 * <code>publishInnerWidth</code> or <code>publishInnerHeight</code> method, respectively.</p>
 * <p><b><i>shrinkWrap</i></b></p>
 * <p>When a dimension uses the <code>shrinkWrap</code> size model, that means the content is measured,
 * then the outer (owner) size is calculated and published.</p>
 * <p>For example, for a shrinkWrap width, the following sequence of calls are made:</p>
 * <ul>
 * <li><code>Ext.layout.component.Component#measureContentWidth</code></li>
 * <li><code>publishOwnerWidth</code>
 * <ul>
 * <li><code>calculateOwnerWidthFromContentWidth</code></li>
 * <li><code>publishInnerWidth</code> (in the event of hitting a min/maxWidth constraint)</li>
 * </ul>
 * </li>
 * </ul>
 * <p><b><i>natural</i></b></p>
 * <p>When a dimension uses the <code>natural</code> size model, the measurement is made on the outer
 * (owner) element. This size is then used to determine the content area in much the same
 * way as if the outer element had a <code>configured</code> or <code>calculated</code> size model.</p>
 * <ul>
 * <li><code>Ext.layout.component.Component#measureOwnerWidth</code></li>
 * <li><code>publishInnerWidth</code></li>
 * </ul>
 * @see ext.Component
 * @see ext.Component#componentLayout
 * @see ext.Component#getSizeModel()
 * @see null
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.component.Auto.html Original Ext JS documentation of 'Ext.layout.component.Auto'
 */
public class AutoComponentLayout extends ComponentLayout {
  /**
   * @param config @inheritDoc
   */
  public function AutoComponentLayout(config:AutoComponentLayout = null) {
    super();
  }

  [ExtConfig]
  /**
   * When publishing height of an auto Component, it is usually not written to the DOM.
   * Setting this to <code>true</code> overrides this behaviour.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.component.Auto.html#cfg-setHeightInDom Original Ext JS documentation of 'setHeightInDom'
   */
  public native function get setHeightInDom():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set setHeightInDom(value:Boolean):void;

  [ExtConfig]
  /**
   * When publishing width of an auto Component, it is usually not written to the DOM.
   * Setting this to <code>true</code> overrides this behaviour.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.component.Auto.html#cfg-setWidthInDom Original Ext JS documentation of 'setWidthInDom'
   */
  public native function get setWidthInDom():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set setWidthInDom(value:Boolean):void;
}
}