package ext.layout.component {
import ext.dom.Element;
import ext.layout.Layout;

[Native("Ext.layout.component.Component", require)]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * <p>This class is intended to be extended or created via the
 * <i>layout</i> (→<code>ext.Component.componentLayout</code>) configuration property.
 * See →<code>ext.Component.componentLayout</code> for additional details.</p>
 * @see ext.Component#componentLayout
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.component.Component.html Original Ext JS documentation of 'Ext.layout.component.Component'
 */
public class ComponentLayout extends Layout {
  /**
   * @inheritDoc
   */
  public function ComponentLayout(config:Layout = null) {
    super();
  }

  /**
   * Returns the element into which rendering must take place.
   * Defaults to the owner Component's encapsulating element.
   * <p>May be overridden in Component layout managers which implement an inner element.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.component.Component.html#method-getRenderTarget Original Ext JS documentation of 'getRenderTarget'
   */
  public native function getRenderTarget():Element;

  /**
   * Returns the owner component's resize element.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.component.Component.html#method-getTarget Original Ext JS documentation of 'getTarget'
   */
  public native function getTarget():Element;
}
}