package ext.layout.container {

[Native("Ext.layout.container.Absolute", require)]
/**
 * This is a layout that inherits the anchoring of →<code>ext.layout.container.AnchorLayout</code> and adds the
 * ability for x/y positioning using the standard x and y component config options.
 * <p>This class is intended to be extended or created via the
 * →<code>ext.container.Container.layout</code> configuration property.
 * See →<code>ext.container.Container.layout</code> for additional details.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.form.Panel', {
 *     title: 'Absolute Layout',
 *     width: 300,
 *     height: 275,
 *     layout: {
 *         type: 'absolute'
 *         // layout-specific configs go here
 *         //itemCls: 'x-abs-layout-item',
 *     },
 *     url:'save-form.php',
 *     defaultType: 'textfield',
 *     items: [{
 *         x: 10,
 *         y: 10,
 *         xtype:'label',
 *         text: 'Send To:'
 *     },{
 *         x: 80,
 *         y: 10,
 *         name: 'to',
 *         anchor:'90%'  // anchor width by percentage
 *     },{
 *         x: 10,
 *         y: 40,
 *         xtype:'label',
 *         text: 'Subject:'
 *     },{
 *         x: 80,
 *         y: 40,
 *         name: 'subject',
 *         anchor: '90%'  // anchor width by percentage
 *     },{
 *         x:0,
 *         y: 80,
 *         xtype: 'textareafield',
 *         name: 'msg',
 *         anchor: '100% 100%'  // anchor width and height
 *     }],
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * @see ext.layout.container.AnchorLayout
 * @see ext.container.Container#layout
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Absolute.html Original Ext JS documentation of 'Ext.layout.container.Absolute'
 */
public class AbsoluteLayout extends AnchorLayout {
  /**
   * @param config @inheritDoc
   */
  public function AbsoluteLayout(config:AbsoluteLayout = null) {
    super();
  }
}
}