package ext.layout.container {

[Native("Ext.layout.container.Accordion", require)]
/**
 * This is a layout that manages multiple Panels in an expandable accordion style such that
 * by default only one Panel can be expanded at any given time (set →<code>multi</code> config
 * to have more open). Each Panel has built-in support for expanding and collapsing.
 * <p>Note: Only Ext Panels and all subclasses of Ext.panel.Panel may be used in an accordion layout
 * Container.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.panel.Panel', {
 *     title: 'Accordion Layout',
 *     width: 300,
 *     height: 300,
 *     defaults: {
 *         // applied to each contained panel
 *         bodyStyle: 'padding:15px'
 *     },
 *     layout: {
 *         // layout-specific configs go here
 *         type: 'accordion',
 *         titleCollapse: false,
 *         animate: true,
 *         activeOnTop: true
 *     },
 *     items: [{
 *         title: 'Panel 1',
 *         html: 'Panel content!'
 *     },{
 *         title: 'Panel 2',
 *         html: 'Panel content!'
 *     },{
 *         title: 'Panel 3',
 *         html: 'Panel content!'
 *     }],
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * @see #multi
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Accordion.html Original Ext JS documentation of 'Ext.layout.container.Accordion'
 */
public class AccordionLayout extends VBoxLayout {
  /**
   * @param config @inheritDoc
   */
  public function AccordionLayout(config:AccordionLayout = null) {
    super();
  }

  [ExtConfig]
  /**
   * Only valid when →<code>multi</code> is <code>false</code> and →<code>animate</code> is <code>false</code>.
   * <p>True to swap the position of each panel as it is expanded so that it becomes the first item
   * in the container, false to keep the panels in the rendered order.</p>
   * @default false
   * @see #multi
   * @see #animate
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Accordion.html#cfg-activeOnTop Original Ext JS documentation of 'activeOnTop'
   */
  public native function get activeOnTop():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set activeOnTop(value:Boolean):void;

  [ExtConfig]
  /**
   * @private
   */
  public native function set animate(value:Boolean):void;

  [ExtConfig]
  /**
   * True to slide the contained panels open and closed during expand/collapse using animation,
   * false to open and close directly with no animation. Note: The layout performs animated
   * collapsing and expanding, <i>not</i> the child Panels.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Accordion.html#cfg-animate Original Ext JS documentation of 'animate'
   */
  public native function get animated():Boolean;

  [ExtConfig]
  /**
   * Child Panels have their width actively managed to fit within the accordion's width.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Accordion.html#cfg-autoWidth Original Ext JS documentation of 'autoWidth'
   */
  public native function get autoWidth():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set autoWidth(value:Boolean):void;

  [ExtConfig]
  /**
   * True to make sure the collapse/expand toggle button always renders first (to the left of)
   * any other tools in the contained Panels' title bars, false to render it last. By default,
   * this will use the →<code>ext.panel.Panel.collapseFirst</code> setting on the panel.
   * If the config option is specified on the layout, it will override the panel value.
   * @default undefined
   * @see ext.panel.Panel#collapseFirst
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Accordion.html#cfg-collapseFirst Original Ext JS documentation of 'collapseFirst'
   */
  public native function get collapseFirst():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set collapseFirst(value:Boolean):void;

  [ExtConfig]
  /**
   * True to adjust the active item's height to fill the available space in the container,
   * false to use the item's current height, or auto height if not explicitly set.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Accordion.html#cfg-fill Original Ext JS documentation of 'fill'
   */
  public native function get fill():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set fill(value:Boolean):void;

  [ExtConfig]
  /**
   * True to hide the contained Panels' collapse/expand toggle buttons, false to display them.
   * When set to true, →<code>titleCollapse</code> is automatically set to true.
   * @default false
   * @see #titleCollapse
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Accordion.html#cfg-hideCollapseTool Original Ext JS documentation of 'hideCollapseTool'
   */
  public native function get hideCollapseTool():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set hideCollapseTool(value:Boolean):void;

  [ExtConfig]
  /**
   * Set to true to enable multiple accordion items to be open at once.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Accordion.html#cfg-multi Original Ext JS documentation of 'multi'
   */
  public native function get multi():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set multi(value:Boolean):void;

  [ExtConfig]
  /**
   * True to allow expand/collapse of each contained panel by clicking anywhere on the title bar,
   * false to allow
   * expand/collapse only when the toggle tool button is clicked. When set to false,
   * →<code>hideCollapseTool</code> should be false also. An explicit
   * →<code>ext.panel.Panel.titleCollapse</code> declared on the panel will override this setting.
   * @default true
   * @see #hideCollapseTool
   * @see ext.panel.Panel#titleCollapse
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Accordion.html#cfg-titleCollapse Original Ext JS documentation of 'titleCollapse'
   */
  public native function get titleCollapse():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set titleCollapse(value:Boolean):void;

  [ExtConfig]
  /**
   * When <code>true</code>, pressing Down or Right arrow key on the
   * focused last accordion panel header will navigate to the first panel; pressing Up
   * or Left arrow key on the focused first accordion panel header will navigate to the
   * last panel.
   * Set this to <code>false</code> to prevent keyboard navigation from wrapping over the edges.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Accordion.html#cfg-wrapOver Original Ext JS documentation of 'wrapOver'
   */
  public native function get wrapOver():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set wrapOver(value:Boolean):void;
}
}