package ext.layout.container {

[Native("Ext.layout.container.Anchor", require)]
/**
 * This is a layout that enables anchoring of contained elements relative to the container's
 * dimensions. If the container is resized, all anchored items are automatically rerendered
 * according to their <code>→anchor</code> rules.
 * <p>This class is intended to be extended or created via the
 * →<code>ext.container.Container.layout</code>: 'anchor' config, and should generally not need
 * to be created directly via the new keyword.</p>
 * <p>AnchorLayout does not have any direct config options (other than inherited ones). By default,
 * AnchorLayout will calculate anchor measurements based on the size of the container itself.
 * However, the container using the AnchorLayout can supply an anchoring-specific config property
 * of <code>anchorSize</code>.</p>
 * <p>If anchorSize is specifed, the layout will use it as a virtual container for the purposes
 * of calculating anchor measurements based on it instead, allowing the container to be sized
 * independently of the anchoring logic if necessary.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.Panel', {
 *     width: 500,
 *     height: 400,
 *     title: "AnchorLayout Panel",
 *     layout: 'anchor',
 *     renderTo: Ext.getBody(),
 *     items: [
 *         {
 *             xtype: 'panel',
 *             title: '75% Width and 20% Height',
 *             anchor: '75% 20%'
 *         },
 *         {
 *             xtype: 'panel',
 *             title: 'Offset -300 Width &amp; -200 Height',
 *             anchor: '-300 -200'
 *         },
 *         {
 *             xtype: 'panel',
 *             title: 'Mixed Offset and Percent',
 *             anchor: '-250 20%'
 *         }
 *     ]
 * });
 * </pre>
 * @see #anchor
 * @see ext.container.Container#layout
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Anchor.html Original Ext JS documentation of 'Ext.layout.container.Anchor'
 */
public class AnchorLayout extends AutoLayout {
  /**
   * @param config @inheritDoc
   */
  public function AnchorLayout(config:AnchorLayout = null) {
    super();
  }

  [ExtConfig]
  /**
   * This configuration option is to be applied to <b>child <code>items</code></b> of a container managed
   * by an <i>Anchor Layout</i> (→<code>ext.layout.container.AnchorLayout</code>).
   * <p>This value is what tells the layout how an item should be anchored to the container. <code>items</code>
   * added to an AnchorLayout accept an anchoring-specific config property of <b>anchor</b>
   * which is a string containing two values: the horizontal anchor value and the vertical anchor
   * value (for example, '100% 50%'). The following types of anchor values are supported:</p>
   * <ul>
   * <li>
   * <p><b>Percentage</b> : Any value between 1 and 100, expressed as a percentage.</p>
   * <p>The first anchor is the percentage width that the item should take up within the container,
   * and the second is the percentage height. For example:</p>
   * <pre>
   * // two values specified
   * anchor: '100% 50%' // render item complete width of the container and
   *                    // 1/2 height of the container
   * // one value specified
   * anchor: '100%'     // the width value; the height will default to auto
   * </pre>
   * </li>
   * <li>
   * <p><b>Offsets</b> : Any positive or negative integer value.</p>
   * <p>This is a raw adjustment where the first anchor is the offset from the right edge
   * of the container, and the second is the offset from the bottom edge. For example:</p>
   * <pre>
   * // two values specified
   * anchor: '-50 -100' // render item the complete width of the container
   *                    // minus 50 pixels and
   *                    // the complete height minus 100 pixels.
   * // one value specified
   * anchor: '-50'      // anchor value is assumed to be the right offset value
   *                    // bottom offset will default to 0
   * </pre>
   * </li>
   * <li>
   * <p><b>Sides</b> : Valid values are <code>right</code> (or <code>r</code>) and <code>bottom</code> (or <code>b</code>).</p>
   * <p>Either the container must have a fixed size or an anchorSize config value defined
   * at render time in order for these to have any effect.</p>
   * </li>
   * <li>
   * <p><b>Mixed</b> :</p>
   * <p>Anchor values can also be mixed as needed. For example, to render the width offset
   * from the container right edge by 50 pixels and 75% of the container's height use:</p>
   * <pre>
   * anchor:   '-50 75%'
   * </pre>
   * </li>
   * </ul>
   * @see ext.layout.container.AnchorLayout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Anchor.html#cfg-anchor Original Ext JS documentation of 'anchor'
   */
  public native function get anchor():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set anchor(value:String):void;

  [ExtConfig]
  /**
   * Default anchor for all child <b>container</b> items applied if no anchor or specific width
   * is set on the child item.
   * @default '100%'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Anchor.html#cfg-defaultAnchor Original Ext JS documentation of 'defaultAnchor'
   */
  public native function get defaultAnchor():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set defaultAnchor(value:String):void;
}
}