package ext.layout.container {
import ext.Base;

[Native("Ext.layout.container.Auto", require)]
/**
 * The AutoLayout is the default layout manager delegated by →<code>ext.container.Container</code> to
 * render any child Components when no <code>→ext.container.Container.layout</code>
 * is configured into a <code>→ext.container.Container.</code> AutoLayout provides
 * only a passthrough of any layout calls to any child containers.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.Panel', {
 *     width: 500,
 *     height: 280,
 *     title: 'AutoLayout Panel',
 *     layout: 'auto',
 *     renderTo: document.body,
 *     items: [{
 *         xtype: 'panel',
 *         title: 'Top Inner Panel',
 *         width: '75%',
 *         height: 90
 *     }, {
 *         xtype: 'panel',
 *         title: 'Bottom Inner Panel',
 *         width: '75%',
 *         height: 90
 *     }]
 * });
 * </pre>
 * @see ext.container.Container
 * @see ext.container.Container#layout
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Auto.html Original Ext JS documentation of 'Ext.layout.container.Auto'
 */
public class AutoLayout extends ContainerLayout {
  /**
   * @param config @inheritDoc
   */
  public function AutoLayout(config:AutoLayout = null) {
    super();
  }

  /**
   * true to rerun the layout if scrollbars are needed.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Auto.html#property-manageOverflow Original Ext JS documentation of 'manageOverflow'
   */
  public native function get manageOverflow():Boolean;

  /**
   * @private
   */
  public native function set manageOverflow(value:Boolean):void;

  /**
   * indicates that this layout will correct cross browser padding differences when the
   * container has overflow.
   * <p>In some browsers the right and/or bottom padding of a container is lost when
   * the container has overflow. If managePadding is true the layout will apply the
   * padding to an inner wrapping element instead of the container element that has the
   * overflow so that paddding will be included in the scrollable area.
   * Note: padding will not be managed if it is configured on the container using
   * a style config or css class. In order to be managed, padding must be added to the
   * container using the appropriate →<code>ext.Component.contentPaddingProperty</code>. For <i>Panels</i> (→<code>ext.panel.Panel</code>) use
   * →<code>ext.panel.Panel.bodyPadding</code>, and for
   * <i>Containers</i> (→<code>ext.container.Container</code>), use
   * →<code>ext.Component.padding</code></p>
   * @default true
   * @see ext.Component#contentPaddingProperty
   * @see ext.panel.Panel
   * @see ext.panel.Panel#bodyPadding
   * @see ext.container.Container
   * @see ext.Component#padding
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Auto.html#property-managePadding Original Ext JS documentation of 'managePadding'
   */
  public native function get managePadding():Boolean;

  /**
   * @private
   */
  public native function set managePadding(value:Boolean):void;

  [ExtConfig]
  /**
   * Set to <code>true</code> to leave space for a vertical scrollbar (if the OS shows space-consuming
   * scrollbars) regardless of whether a scrollbar is needed.
   * <p>This is useful if content height changes during application usage, but you do not want
   * the calculated width of child items to change when a scrollbar appears or disappears.
   * The scrollbar will appear in the reserved space, and the calculated width
   * of child Components will not change.</p>
   * <p><b>Example:</b></p>
   * <pre>
   * Ext.define('Employee', {
   *     extend: 'Ext.data.Model',
   *     fields: [
   *        {name: 'rating', type: 'int'},
   *        {name: 'salary', type: 'float'},
   *        {name: 'name'}
   *     ]
   * });
   *
   * function createFakeData(count) {
   *     var firstNames = ['Screech', 'Kelly', 'Zach', 'Jessie', 'Lisa', 'A.C.', 'Richard'],
   *         lastNames = ['Powers', 'Kapowski', 'Morris', 'Spano', 'Turtle', 'Slater',
   *                      'Belding'],
   *         ratings = [1, 2, 3, 4, 5],
   *         salaries = [100, 400, 900, 1500, 1000000],
   *         data = [];
   *
   *     for (var i = 0; i &lt; (count || 25); i++) {
   *         var ratingId = Math.floor(Math.random() &#42; ratings.length),
   *             salaryId = Math.floor(Math.random() &#42; salaries.length),
   *             firstNameId = Math.floor(Math.random() &#42; firstNames.length),
   *             lastNameId = Math.floor(Math.random() &#42; lastNames.length),
   *
   *             rating = ratings[ratingId],
   *             salary = salaries[salaryId],
   *             name = Ext.String.format(
   *                 "{0} {1}", firstNames[firstNameId], lastNames[lastNameId]
   *             );
   *
   *         data.push({
   *             rating: rating,
   *             salary: salary,
   *             name: name
   *         });
   *     }
   *     store.loadData(data);
   * }
   *
   * // create the Data Store
   * var store = Ext.create('Ext.data.Store', {
   *     id: 'store',
   *     model: 'Employee',
   *     proxy: {
   *         type: 'memory'
   *     }
   * });
   * createFakeData(10);
   *
   * var grid = Ext.create('Ext.grid.Panel', {
   *     title: 'Grid loaded with varying number of records',
   *     anchor: '100%',
   *     store: store,
   *     columns: [{
   *         xtype: 'rownumberer',
   *         width: 40,
   *         sortable: false
   *     },{
   *         text: 'Name',
   *         flex: 1,
   *         sortable: true,
   *         dataIndex: 'name'
   *     },{
   *         text: 'Rating',
   *         width: 125,
   *         sortable: true,
   *         dataIndex: 'rating'
   *     },{
   *         text: 'Salary',
   *         width: 125,
   *         sortable: true,
   *         dataIndex: 'salary',
   *         align: 'right',
   *         renderer: Ext.util.Format.usMoney
   *     }]
   * });
   *
   * Ext.create('Ext.panel.Panel', {
   *     renderTo: document.body,
   *     width: 800,
   *     height: 600,
   *     layout: {
   *         type: 'anchor',
   *         reserveScrollbar: true // There will be a gap even when there's no scrollbar
   *     },
   *     scrollable: true,
   *     items: grid,
   *     tbar: {
   *         defaults: {
   *             handler: function(b) {
   *                 createFakeData(b.count);
   *             }
   *         },
   *         items: [{
   *              text: '10 Items',
   *              count: 10
   *         },{
   *              text: '100 Items',
   *              count: 100
   *         },{
   *              text: '300 Items',
   *              count: 300
   *         },{
   *              text: '1000 Items',
   *              count: 1000
   *         },{
   *              text: '5000 Items',
   *              count: 5000
   *         }]
   *     }
   * });
   * </pre>
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Auto.html#cfg-reserveScrollbar Original Ext JS documentation of 'reserveScrollbar'
   */
  public native function get reserveScrollbar():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set reserveScrollbar(value:Boolean):void;

  /**
   * Handles overflow processing for a container. In addition to the ownerContext
   * passed to the →<code>calculate()</code> method, this method also needs the containerSize
   * (the object returned by →<code>getContainerSize()</code>).
   * @see #calculate()
   * @see #getContainerSize()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Auto.html#method-calculateOverflow Original Ext JS documentation of 'calculateOverflow'
   */
  protected native function calculateOverflow(ownerContext:Base):void;

  /**
   * Returns the container size (that of the target). Only the fixed-sized dimensions can
   * be returned because the shrinkWrap dimensions are based on the contentWidth/Height
   * as determined by the container layout.
   * <p>If the →<code>calculateOverflow()</code> method is used and if →<code>manageOverflow</code> is
   * true, this will adjust the width/height by the size of scrollbars.</p>
   * @param ownerContext The owner's context item.
   * @param inDom True if the container size must be in the DOM.
   * @default false
   * @return The size
   * <ul>
   * <li><code>width:Number</code> (optional) —
   * The width
   * </li>
   * <li><code>height:Number</code> (optional) —
   * The height
   * </li>
   * </ul>
   * @see #calculateOverflow()
   * @see #manageOverflow
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Auto.html#method-getContainerSize Original Ext JS documentation of 'getContainerSize'
   */
  override protected native function getContainerSize(ownerContext:Base, inDom:Boolean = false):Object;

  /**
   * Returns the overflow-x style of the render target.
   * Note: If overflow is configured on a container using style or css class this method
   * will read the dom the first time it is called. It is therefore preferable for
   * performance reasons to use the →<code>ext.Component.scrollable</code> config when
   * horizontal overflow is desired.
   * @see ext.Component#scrollable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Auto.html#method-getOverflowXStyle Original Ext JS documentation of 'getOverflowXStyle'
   */
  protected native function getOverflowXStyle(ownerContext:Base):String;

  /**
   * Returns the overflow-y style of the render target.
   * Note: If overflow is configured on a container using style or css class this method
   * will read the dom the first time it is called. It is therefore preferable for
   * performance reasons to use the →<code>ext.Component.scrollable</code> config when
   * vertical overflow is desired.
   * @see ext.Component#scrollable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Auto.html#method-getOverflowYStyle Original Ext JS documentation of 'getOverflowYStyle'
   */
  protected native function getOverflowYStyle(ownerContext:Base):String;

  /**
   * This method sets the height and/or width of the outerCt/innerCt to adjust for the
   * following browser-specific issues...
   * <ol>
   * <li>
   * <p>In some browsers a percentage-height element ignores the horizontal scrollbar
   * of its parent (see Ext.supports.PercentageHeightOverflowBug). If the browser is
   * affected by this bug the outerCt needs a pixel height in order to support
   * percentage-height children when not shrink-wrapping height. If the browser is not
   * affected by this bug, a height of 100% is assigned to the outerCt (see
   * beginLayoutCycle).</p>
   * </li>
   * <li>
   * <p>IE8 mode has a bug with percentage height children. if the innerCt has
   * a height of 100%, has padding, and has a child item with a percentage height, that
   * child item will be sized as a percentage of the parent's height plus padding height.
   * In other words, a child with height:50% would have its height caclulated thusly:
   * (parentHeight + parentPaddingHeight) &#42; 0.5
   * To fix this, we have to give the innerCt a pixel height.</p>
   * </li>
   * </ol>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Auto.html#method-setCtSizeIfNeeded Original Ext JS documentation of 'setCtSizeIfNeeded'
   */
  protected native function setCtSizeIfNeeded(ownerContext:Base, containerSize:Object):void;
}
}