package ext.layout.container {

[Native("Ext.layout.container.Border", require)]
/**
 * This is a multi-pane, application-oriented UI layout style that supports multiple nested panels,
 * automatic bars between regions and built-in
 * <i>expanding and collapsing</i> (→<code>ext.panel.Panel.collapsible</code>) of regions.
 * <p>This class is intended to be extended or created via the <code>layout: 'border'</code>
 * →<code>ext.container.Container.layout</code> config, and should generally not need to be created
 * directly via the new keyword.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.panel.Panel', {
 *     width: 500,
 *     height: 300,
 *     title: 'Border Layout',
 *     layout: 'border',
 *     items: [{
 *         title: 'South Region is resizable',
 *         region: 'south',     // position for region
 *         xtype: 'panel',
 *         height: 100,
 *         split: true,         // enable resizing
 *         margin: '0 5 5 5'
 *     },{
 *         // xtype: 'panel' implied by default
 *         title: 'West Region is collapsible',
 *         region:'west',
 *         xtype: 'panel',
 *         margin: '5 0 0 5',
 *         width: 200,
 *         collapsible: true,   // make collapsible
 *         id: 'west-region-container',
 *         layout: 'fit'
 *     },{
 *         title: 'Center Region',
 *         region: 'center',     // center region is required, no width/height specified
 *         xtype: 'panel',
 *         layout: 'fit',
 *         margin: '5 5 0 0'
 *     }],
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * <p><b>Notes</b></p>
 * <ul>
 * <li>
 * <p>When using the split option, the layout will automatically insert a
 * →<code>ext.resizer.Splitter</code> into the appropriate place. This will modify the underlying
 * →<code>ext.container.Container.items</code> collection in the container.</p>
 * </li>
 * <li>
 * <p>Any Container using the Border layout <b>must</b> have a child item with <code>region:'center'</code>.
 * The child item in the center region will always be resized to fill the remaining space
 * not used by the other regions in the layout.</p>
 * </li>
 * <li>
 * <p>Any child items with a region of <code>west</code> or <code>east</code> may be configured with either an initial
 * <code>width</code>, or a →<code>ext.layout.container.BoxLayout.flex</code> value, or an initial percentage width
 * <b>string</b> (Which is simply divided by 100 and used as a flex value).
 * The 'center' region has a flex value of <code>1</code>.</p>
 * </li>
 * <li>
 * <p>Any child items with a region of <code>north</code> or <code>south</code> may be configured with either an initial
 * <code>height</code>, or a →<code>ext.layout.container.BoxLayout.flex</code> value, or an initial percentage height
 * <b>string</b> (Which is simply divided by 100 and used as a flex value).
 * The 'center' region has a flex value of <code>1</code>.</p>
 * </li>
 * <li>
 * <p><b>There is no BorderLayout.Region class in ExtJS 4.0+</b></p>
 * </li>
 * </ul>
 * @see ext.panel.Panel#collapsible
 * @see ext.container.Container#layout
 * @see ext.resizer.Splitter
 * @see ext.container.Container#items
 * @see ext.layout.container.BoxLayout#flex
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Border.html Original Ext JS documentation of 'Ext.layout.container.Border'
 */
public class BorderLayout extends ContainerLayout {
  /**
   * @param config @inheritDoc
   */
  public function BorderLayout(config:BorderLayout = null) {
    super();
  }

  [ExtConfig]
  /**
   * Sets the padding to be applied to all child items managed by this layout.
   * <p>This property can be specified as a string containing space-separated, numeric
   * padding values. The order of the sides associated with each value matches the way
   * CSS processes padding values:</p>
   * <ul>
   * <li>If there is only one value, it applies to all sides.</li>
   * <li>If there are two values, the top and bottom borders are set to the first value
   * and the right and left are set to the second.</li>
   * <li>If there are three values, the top is set to the first value, the left and right
   * are set to the second, and the bottom is set to the third.</li>
   * <li>If there are four values, they apply to the top, right, bottom, and left,
   * respectively.</li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Border.html#cfg-padding Original Ext JS documentation of 'padding'
   */
  public native function get padding():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set padding(value:*):void;

  [ExtConfig]
  /**
   * The default weights to assign to regions in the border layout. These values are
   * used when a region does not contain a <code>weight</code> property. This object must have
   * properties for all regions ("north", "south", "east" and "west").
   * <p><b>IMPORTANT:</b> Since this is an object, changing its properties will impact ALL
   * instances of Border layout. If this is not desired, provide a replacement object as
   * a config option instead:</p>
   * <pre>
   *  layout: {
   *      type: 'border',
   *      regionWeights: {
   *          west: 20,
   *          north: 10,
   *          south: -10,
   *          east: -20
   *      }
   *  }
   * </pre>
   * <p>The region with the highest weight is assigned space from the border before other
   * regions. Regions of equal weight are assigned space based on their position in the
   * owner's items list (first come, first served).</p>
   * @default {
   *     north: 20,
   *     south: 10,
   *     center: 0,
   *     west: -10,
   *     east: -20
   * }
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Border.html#cfg-regionWeights Original Ext JS documentation of 'regionWeights'
   */
  public native function get regionWeights():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set regionWeights(value:Object):void;

  [ExtConfig]
  /**
   * This configuration option is to be applied to the <b>child <code>items</code></b> managed by this layout.
   * Each region with <code>split:true</code> will get a <i>Splitter</i> (→<code>null</code>) that
   * allows for manual resizing of the container. Except for the <code>center</code> region.
   * <p>This option can also accept an object of configurations from the
   * →<code>null</code>. An example of this would be:</p>
   * <pre>
   * {
   *     title: 'North',
   *     region: 'north',
   *     height: 100,
   *     collapsible: true,
   *     split: {
   *         size: 20
   *     }
   * }
   * </pre>
   * @see null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Border.html#cfg-split Original Ext JS documentation of 'split'
   */
  public native function get split():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set split(value:*):void;

  [ExtConfig]
  /**
   * This configuration option is to be applied to the <b>child <code>items</code></b> managed by this layout
   * and is used in conjunction with →<code>split</code>. By default, when specifying →<code>split</code>,
   * the region can be dragged to be resized. Set this option to false to show the split bar
   * but prevent resizing.
   * @default true
   * @see #split
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Border.html#cfg-splitterResize Original Ext JS documentation of 'splitterResize'
   */
  public native function get splitterResize():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set splitterResize(value:Boolean):void;
}
}