package ext.layout.container {

[Native("Ext.layout.container.Box", require)]
/**
 * Base Class for HBoxLayout and VBoxLayout Classes. Generally it should not need to be used
 * directly.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Box.html Original Ext JS documentation of 'Ext.layout.container.Box'
 */
public class BoxLayout extends ContainerLayout {
  /**
   * @param config @inheritDoc
   */
  public function BoxLayout(config:BoxLayout = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * Controls how the child items of the container are aligned. The value is used to
   * position items "perpendicularly". That is, for horizontal boxes (where <code>→vertical</code>
   * is <code>false</code>), then this will position items vertically. Otherwise, this will position
   * items horizontally. The acceptable values for this property are best explained in
   * context with the value of <code>→vertical</code>.
   * <p>If <code>→vertical</code> is <code>false</code> then this layout is behaving as an <code>hbox</code> and this config
   * operates as follows:</p>
   * <ul>
   * <li><b>begin</b> : Child items are aligned vertically at the top of the container.</li>
   * <li><b>middle</b> : Child items are vertically centered in the container.</li>
   * <li><b>end</b> : Child items are aligned vertically at the bottom of the container.</li>
   * <li><b>stretch</b> : Child items are stretched vertically to fill the height of the container.</li>
   * <li><b>stretchmax</b> : Child items are stretched vertically to the height of the largest
   * item.</li>
   * </ul>
   * <p>If <code>→vertical</code> is <code>true</code> then this layout is behaving as an <code>vbox</code> and this config
   * operates as follows:</p>
   * <ul>
   * <li><b>begin</b> : Child items are aligned horizontally at the left side of the container.</li>
   * <li><b>middle</b> : Child items are horizontally centered in the container.</li>
   * <li><b>end</b> : Child items are aligned horizontally at the right of the container.</li>
   * <li><b>stretch</b> : Child items are stretched horizontally to fill the width of the
   * container.</li>
   * <li><b>stretchmax</b> : Child items are stretched horizontally to the size of the largest
   * item.</li>
   * </ul>
   * <p>For backwards compatibility, the following values are also recognized:</p>
   * <ul>
   * <li><b>left</b> : Same as <b>begin</b>.</li>
   * <li><b>top</b> : Same as <b>begin</b>.</li>
   * <li><b>center</b> : Same as <b>middle</b>.</li>
   * <li><b>right</b> : Same as <b>end</b>.</li>
   * <li><b>bottom</b> : Same as <b>end</b>.</li>
   * </ul>
   * @default "begin"
   * @see #vertical
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Box.html#cfg-align Original Ext JS documentation of 'align'
   * @see #getAlign()
   * @see #setAlign()
   */
  public native function get align():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set align(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The Math method
   * to use for rounding fractional pixels when <code>→align:middle</code> is used.
   * The possible values are:
   * <ul>
   * <li><a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/round">round</a></li>
   * <li><a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/floor">floor</a></li>
   * <li><a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/ceil">ceil</a></li>
   * </ul>
   * @default 'round'
   * @see #align
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Box.html#cfg-alignRoundingMethod Original Ext JS documentation of 'alignRoundingMethod'
   * @see #getAlignRoundingMethod()
   * @see #setAlignRoundingMethod()
   */
  public native function get alignRoundingMethod():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set alignRoundingMethod(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Limits the size of <i>aligned</i> (→<code>align</code>) components to the size of the container
   * under certain circumstances. Firstly, the container's height (for <code>hbox</code>) or width
   * (for <code>vbox</code>) must not be determined by the size of the child components. Secondly,
   * the child components must have <i>shrinkwrap</i> (→<code>ext.Component.shrinkWrap</code>)
   * enabled for this dimension.
   * @default false
   * @see #align
   * @see ext.Component#shrinkWrap
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Box.html#cfg-constrainAlign Original Ext JS documentation of 'constrainAlign'
   * @see #getConstrainAlign()
   * @see #setConstrainAlign()
   */
  public native function get constrainAlign():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set constrainAlign(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * This flag can be set to <code>false</code> to ignore the <code>split</code> config on box items. This is
   * set to <code>false</code> by <code>→ext.layout.container.AccordionLayout</code>.
   * @default true
   * @see ext.layout.container.AccordionLayout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Box.html#cfg-enableSplitters Original Ext JS documentation of 'enableSplitters'
   * @see #getEnableSplitters()
   * @see #setEnableSplitters()
   */
  public native function get enableSplitters():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set enableSplitters(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * An overflow handler or config object for an overflow handler. This is typically
   * specified as one of the following strings:
   * <ul>
   * <li><code>scroller</code> - Scroller buttons are rendered before and after the content.</li>
   * <li><code>menu</code> - Overflowing items are rendered into a menu, and a button is rendered
   * after the items, which shows the menu when clicked.</li>
   * </ul>
   * <p>NOTE: This config is currently only supported when box layout is used by the
   * following components:</p>
   * <ul>
   * <li>→<code>ext.toolbar.Toolbar</code></li>
   * <li>→<code>ext.menu.Menu</code></li>
   * <li>→<code>ext.toolbar.Breadcrumb</code></li>
   * <li>→<code>ext.tab.TabBar</code></li>
   * </ul>
   * <p>Components where <code>→overflowHandler</code> is not supported should use
   * <code>→ext.Component.scrollable:true</code> if they have overflowing
   * content.</p>
   * @default null
   * @see ext.toolbar.Toolbar
   * @see ext.menu.Menu
   * @see ext.toolbar.Breadcrumb
   * @see ext.tab.TabBar
   * @see #overflowHandler
   * @see ext.Component#scrollable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Box.html#cfg-overflowHandler Original Ext JS documentation of 'overflowHandler'
   * @see #getOverflowHandler()
   * @see #setOverflowHandler()
   */
  public native function get overflowHandler():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set overflowHandler(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * Controls how the child items of the container are packed together. Acceptable
   * configuration values for this property are:
   * <ul>
   * <li><b>start</b> - child items are packed together at <b>left</b> (HBox) or <b>top</b>
   * (VBox) side of container (<i>default</i>&#42;)</li>
   * <li><b>center</b> - child items are packed together at <b>mid-width</b> (HBox) or
   * <b>mid-height</b> (VBox) of container</li>
   * <li><b>end</b> - child items are packed together at <b>right</b> (HBox) or <b>bottom</b>
   * (VBox) side of container</li>
   * </ul>
   * @default 'start'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Box.html#cfg-pack Original Ext JS documentation of 'pack'
   * @see #getPack()
   * @see #setPack()
   */
  public native function get pack():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set pack(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Sets the padding to be applied to all child items managed by this layout.
   * <p>This property must be specified as a string containing space-separated, numeric
   * padding values. The order of the sides associated with each value matches the
   * way CSS processes padding values:</p>
   * <ul>
   * <li>If there is only one value, it applies to all sides.</li>
   * <li>If there are two values, the top and bottom borders are set to the first
   * value and the right and left are set to the second.</li>
   * <li>If there are three values, the top is set to the first value, the left and
   * right are set to the second, and the bottom is set to the third.</li>
   * <li>If there are four values, they apply to the top, right, bottom, and left,
   * respectively.</li>
   * </ul>
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Box.html#cfg-padding Original Ext JS documentation of 'padding'
   * @see #getPadding()
   * @see #setPadding()
   */
  public native function get padding():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set padding(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Allows stretchMax calculation to take into account the max perpendicular size
   * (height for HBox layout and width for VBox layout) of another Box layout when
   * calculating its maximum perpendicular child size.
   * <p>If specified as a string, this may be either a known Container ID, or a
   * ComponentQuery selector which is rooted at this layout's Container (ie, to find
   * a sibling, use <code>"^&gt;#siblingItemId</code>).</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Box.html#cfg-stretchMaxPartner Original Ext JS documentation of 'stretchMaxPartner'
   * @see #getStretchMaxPartner()
   * @see #setStretchMaxPartner()
   */
  public native function get stretchMaxPartner():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set stretchMaxPartner(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * Set to <code>true</code> to switch the layout to <code>vbox</code>.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Box.html#cfg-vertical Original Ext JS documentation of 'vertical'
   * @see #getVertical()
   * @see #setVertical()
   */
  public native function get vertical():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set vertical(value:Boolean):void;

  /**
   * This method is called to (re)cache our understanding of flexes.
   * This happens during beginLayoutCycle and may need to be called again
   * if the flexes are changed during the layout (e.g., like ColumnLayout).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Box.html#method-cacheFlexes Original Ext JS documentation of 'cacheFlexes'
   */
  protected native function cacheFlexes(ownerContext:Object):void;

  /**
   * Returns the value of <code>align</code>.
   * @see #align
   */
  public native function getAlign():String;

  /**
   * Returns the value of <code>alignRoundingMethod</code>.
   * @see #alignRoundingMethod
   */
  public native function getAlignRoundingMethod():String;

  /**
   * Returns the value of <code>constrainAlign</code>.
   * @see #constrainAlign
   */
  public native function getConstrainAlign():Boolean;

  /**
   * Returns the value of <code>enableSplitters</code>.
   * @see #enableSplitters
   */
  public native function getEnableSplitters():Boolean;

  /**
   * Returns the value of <code>overflowHandler</code>.
   * @see #overflowHandler
   */
  public native function getOverflowHandler():*;

  /**
   * Returns the value of <code>pack</code>.
   * @see #pack
   */
  public native function getPack():String;

  /**
   * Returns the value of <code>padding</code>.
   * @see #padding
   */
  public native function getPadding():String;

  /**
   * Returns the value of <code>stretchMaxPartner</code>.
   * @see #stretchMaxPartner
   */
  public native function getStretchMaxPartner():*;

  /**
   * Returns the value of <code>vertical</code>.
   * @see #vertical
   */
  public native function getVertical():Boolean;

  /**
   * Sets the value of <code>align</code>.
   * @param align The new value.
   * @see #align
   */
  public native function setAlign(align:String):void;

  /**
   * Sets the value of <code>alignRoundingMethod</code>.
   * @param alignRoundingMethod The new value.
   * @see #alignRoundingMethod
   */
  public native function setAlignRoundingMethod(alignRoundingMethod:String):void;

  /**
   * Sets the value of <code>constrainAlign</code>.
   * @param constrainAlign The new value.
   * @see #constrainAlign
   */
  public native function setConstrainAlign(constrainAlign:Boolean):void;

  /**
   * Sets the value of <code>enableSplitters</code>.
   * @param enableSplitters The new value.
   * @see #enableSplitters
   */
  public native function setEnableSplitters(enableSplitters:Boolean):void;

  /**
   * Sets the value of <code>overflowHandler</code>.
   * @param overflowHandler The new value.
   * @see #overflowHandler
   */
  public native function setOverflowHandler(overflowHandler:*):void;

  /**
   * Sets the value of <code>pack</code>.
   * @param pack The new value.
   * @see #pack
   */
  public native function setPack(pack:String):void;

  /**
   * Sets the value of <code>padding</code>.
   * @param padding The new value.
   * @see #padding
   */
  public native function setPadding(padding:String):void;

  /**
   * Sets the value of <code>stretchMaxPartner</code>.
   * @param stretchMaxPartner The new value.
   * @see #stretchMaxPartner
   */
  public native function setStretchMaxPartner(stretchMaxPartner:*):void;

  /**
   * Sets the value of <code>vertical</code>.
   * @param vertical The new value.
   * @see #vertical
   */
  public native function setVertical(vertical:Boolean):void;
}
}