package ext.layout.container {

[Native("Ext.layout.container.Center", require)]
/**
 * This layout manager is used to center contents within a container. As a subclass of
 * <i>fit layout</i> (→<code>ext.layout.container.FitLayout</code>), CenterLayout expects to have one child
 * item; multiple items will be placed overlapping. The layout does not require any config
 * options. Items in the container can use percentage width or height rather than be fit
 * to the full size of the container.
 * <p>Example usage:</p>
 * <pre>
 *  // The content panel is centered in the container
 *
 *  var p = Ext.create('Ext.Panel', {
 *      title: 'Center Layout',
 *      layout: 'center',
 *      items: [{
 *          title: 'Centered Content',
 *          width: '75%',  // assign 75% of the container width to the item
 *          html: 'Some content'
 *      }]
 *  });
 * </pre>
 * <p>If you leave the title blank and specify no border you can create a non-visual, structural
 * container just for centering the contents.</p>
 * <pre>
 *  var p = Ext.create('Ext.Container', {
 *      layout: 'center',
 *      items: [{
 *          title: 'Centered Content',
 *          width: 300,
 *          height: '90%', // assign 90% of the container height to the item
 *          html: 'Some content'
 *      }]
 *  });
 * </pre>
 * @see ext.layout.container.FitLayout
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Center.html Original Ext JS documentation of 'Ext.layout.container.Center'
 */
public class CenterLayout extends FitLayout {
  /**
   * @param config @inheritDoc
   */
  public function CenterLayout(config:CenterLayout = null) {
    super();
  }
}
}