package ext.layout.container {

[Native("Ext.layout.container.CheckboxGroup", require)]
/**
 * This layout implements the column arrangement for →<code>ext.form.CheckboxGroup</code> and
 * →<code>ext.form.RadioGroup</code>. It groups the component's sub-items into columns
 * based on the component's →<code>ext.form.CheckboxGroup.columns</code> and
 * →<code>ext.form.CheckboxGroup.vertical</code> config properties.
 * @see ext.form.CheckboxGroup
 * @see ext.form.RadioGroup
 * @see ext.form.CheckboxGroup#columns
 * @see ext.form.CheckboxGroup#vertical
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.CheckboxGroup.html Original Ext JS documentation of 'Ext.layout.container.CheckboxGroup'
 */
public class CheckboxGroupLayout extends ContainerLayout {
  /**
   * @param config @inheritDoc
   */
  public function CheckboxGroupLayout(config:CheckboxGroupLayout = null) {
    super();
  }

  [ExtConfig]
  /**
   * By default, CheckboxGroup allocates all available space to the configured columns
   * meaning that column are evenly spaced across the container.
   * <p>To have each column only be wide enough to fit the container Checkboxes (or Radios),
   * set <code>→autoFlex</code> to <code>false</code></p>
   * @default true
   * @see #autoFlex
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.CheckboxGroup.html#cfg-autoFlex Original Ext JS documentation of 'autoFlex'
   */
  public native function get autoFlex():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set autoFlex(value:Boolean):void;

  /**
   * Iterates over all passed items, ensuring they are rendered. If the items
   * are already rendered, also determines if the items are in the proper place in the dom.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.CheckboxGroup.html#method-renderItems Original Ext JS documentation of 'renderItems'
   */
  override protected native function renderItems(items:*, target:*):void;
}
}