package ext.layout.container {
import ext.Base;
import ext.Component;
import ext.dom.Element;
import ext.layout.Layout;
import ext.util.IElementContainer;

[Native("Ext.layout.container.Container", require)]
/**
 * This class is intended to be extended or created via the
 * →<code>ext.container.Container.layout</code> configuration property.
 * See →<code>ext.container.Container.layout</code> for additional details.
 * @see ext.container.Container#layout
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Container.html Original Ext JS documentation of 'Ext.layout.container.Container'
 */
public class ContainerLayout extends Layout implements IElementContainer {
  /**
   * @param config @inheritDoc
   */
  public function ContainerLayout(config:ContainerLayout = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * The canonical form of <code>→childEls</code> is an object keyed by child's property name
   * with values that are objects with the following properties.
   * <ul>
   * <li><code>itemId</code> - The id to combine with the Component's id that is the id of the
   * child element.</li>
   * <li><code>id</code> - The id of the child element.</li>
   * <li><code>leaf</code> - Set to <code>true</code> to ignore content when scanning for childEls. This
   * should be set on things like the generated content for an <code>→ext.view.DataView</code>.</li>
   * <li><code>select</code>: A selector that will be passed to →<code>ext.dom.Element.select()</code>.</li>
   * <li><code>selectNode</code>: A selector that will be passed to
   * →<code>ext.dom.Element.selectNode()</code>.</li>
   * </ul>
   * <p>For example:</p>
   * <pre>
   *  childEls: {
   *      button: true,
   *      buttonText: 'text',
   *      buttonImage: {
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above is translated into the following complete form:</p>
   * <pre>
   *  childEls: {
   *      button: {
   *          name: 'button',
   *          itemId: 'button'
   *      },
   *      buttonText: {
   *          name: 'buttonText',
   *          itemId: 'text'
   *      },
   *      buttonImage: {
   *          name: 'buttonImage',
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above can be provided as an array like so:</p>
   * <pre>
   *  childEls: [
   *      'button',
   *      { name: 'buttonText', itemId: 'text' },
   *      { name: 'buttonImage', itemId: 'image' }
   *  }
   * </pre>
   * <p>For example, a Component which renders a title and body text:</p>
   * <p><b>Example:</b></p>
   * <pre>
   * Ext.create('Ext.Component', {
   *     renderTo: Ext.getBody(),
   *     renderTpl: [
   *         '&lt;h1 id="{id}-title" data-ref="title"&gt;{title}&lt;/h1&gt;',
   *         '&lt;p&gt;{msg}&lt;/p&gt;',
   *     ],
   *     renderData: {
   *         title: "Error",
   *         msg: "Something went wrong"
   *     },
   *     childEls: ["title"],
   *     listeners: {
   *         afterrender: function(cmp){
   *             // After rendering the component will have a title property
   *             cmp.title.setStyle({color: "red"});
   *         }
   *     }
   * });
   * </pre>
   * <p><b>Note:</b> <code>childEl</code>s in the →<code>ext.Component.renderTpl</code>
   * must be referenced in a <b>data-ref</b> attribute. Notice in the above example
   * that the "title" <code>childEl</code> is set in the <code>renderTpl</code> using
   * <b>data-ref="title"</b>.</p>
   * <p>When using <code>select</code>, the property will be an instance of →<code>ext.dom.CompositeElement</code>.
   * In all other cases, the property will be an →<code>ext.dom.Element</code> or <code>null</code>
   * if not found.</p>
   * <p>Care should be taken when using <code>select</code> or <code>selectNode</code> to find child elements.
   * The following issues should be considered:</p>
   * <ul>
   * <li>Performance: using selectors can be 10x slower than id lookup.</li>
   * <li>Over-selecting: selectors are applied after the DOM elements for all children
   * have been rendered, so selectors can match elements from child components
   * (including nested versions of the same component) accidentally.</li>
   * </ul>
   * <p>This above issues are most important when using <code>select</code> since it returns multiple
   * elements.</p>
   * @default {}
   * @see #childEls
   * @see ext.view.DataView
   * @see ext.dom.Element#select()
   * @see ext.dom.Element#selectNode()
   * @see ext.Component#renderTpl
   * @see ext.dom.CompositeElement
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.ElementContainer.html#cfg-childEls Original Ext JS documentation of 'childEls'
   * @see #getChildEls()
   * @see #setChildEls()
   */
  public native function get childEls():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set childEls(value:*):void;

  [ExtConfig]
  /**
   * An optional extra CSS class that will be added to the container. This can be useful for
   * adding customized styles to the container or any of its children using standard CSS
   * rules. See →<code>ext.Component</code>.→<code>ext.Component.componentCls</code> also.
   * @see ext.Component
   * @see ext.Component#componentCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Container.html#cfg-itemCls Original Ext JS documentation of 'itemCls'
   */
  public native function get itemCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set itemCls(value:String):void;

  /**
   * In addition to work done by our base classes, containers benefit from some extra
   * cached data. The following properties are added to the ownerContext:
   * <ul>
   * <li>visibleItems: the result of →<code>getVisibleItems()</code></li>
   * <li>childItems: the ContextItem[] for each visible item</li>
   * <li>targetContext: the ContextItem for the →<code>getTarget()</code> element</li>
   * </ul>
   * @param ownerContext The context item for the layout's owner
   * component.
   * @see #getVisibleItems()
   * @see #getTarget()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Container.html#method-beginLayout Original Ext JS documentation of 'beginLayout'
   */
  override public native function beginLayout(ownerContext:Base):void;

  /**
   * Adds layout's itemCls and owning Container's itemCls
   * @param item The item to be configured
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Container.html#method-configureItem Original Ext JS documentation of 'configureItem'
   */
  override protected native function configureItem(item:Component):void;

  /**
   * Returns the value of <code>childEls</code>.
   * @see #childEls
   */
  public native function getChildEls():*;

  /**
   * Returns the container size (that of the target). Only the fixed-sized dimensions can
   * be returned because the shrinkWrap dimensions are based on the contentWidth/Height
   * as determined by the container layout.
   * @param ownerContext The owner's context item.
   * @param inDom True if the container size must be in the DOM.
   * @default false
   * @return The size
   * <ul>
   * <li><code>width:Number</code> (optional) —
   * The width
   * </li>
   * <li><code>height:Number</code> (optional) —
   * The height
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Container.html#method-getContainerSize Original Ext JS documentation of 'getContainerSize'
   */
  protected native function getContainerSize(ownerContext:Base, inDom:Boolean = false):Object;

  /**
   * Returns the element into which extra functional DOM elements can be inserted.
   * Defaults to the owner Component's encapsulating element.
   * <p>May be overridden in Component layout managers which implement a
   * <i>component render target</i> (→<code>getRenderTarget()</code>) which must only contain child components.</p>
   * @see #getRenderTarget()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Container.html#method-getElementTarget Original Ext JS documentation of 'getElementTarget'
   */
  public native function getElementTarget():Element;

  [ArrayElementType("ext.Component")]
  /**
   * Returns an array of child components either for a render phase (Performed in the beforeLayout
   * method of the layout's base class), or the layout phase (onLayout).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Container.html#method-getLayoutItems Original Ext JS documentation of 'getLayoutItems'
   */
  override protected native function getLayoutItems():Array;

  /**
   * Returns the element into which rendering must take place. Defaults to the owner Container's
   * target element.
   * <p>May be overridden in layout managers which implement an inner element.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Container.html#method-getRenderTarget Original Ext JS documentation of 'getRenderTarget'
   */
  public native function getRenderTarget():Element;

  /**
   * Returns all items that are rendered
   * @return All matching items
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Container.html#method-getRenderedItems Original Ext JS documentation of 'getRenderedItems'
   */
  protected native function getRenderedItems():Array;

  /**
   * Returns the owner component's resize element.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Container.html#method-getTarget Original Ext JS documentation of 'getTarget'
   */
  public native function getTarget():Element;

  /**
   * Returns all items that are both rendered and visible
   * @return All matching items
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Container.html#method-getVisibleItems Original Ext JS documentation of 'getVisibleItems'
   */
  public native function getVisibleItems():Array;

  /**
   * Sets the value of <code>childEls</code>.
   * @param childEls The new value.
   * @see #childEls
   */
  public native function setChildEls(childEls:*):void;
}
}