package ext.layout.container {

[Native("Ext.layout.container.Fit", require)]
/**
 * This is a base class for layouts that contain a single item that automatically expands to fill
 * the layout's container. This class is intended to be extended or created via the <code>layout: 'fit'</code>
 * →<code>ext.container.Container.layout</code> config, and should generally not need to be created
 * directly via the new keyword.
 * <p>Fit layout does not have any direct config options (other than inherited ones). To fit a panel
 * to a container using Fit layout, simply set <code>layout: 'fit'</code> on the container and add
 * a single panel to it.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.panel.Panel', {
 *     title: 'Fit Layout',
 *     width: 300,
 *     height: 150,
 *     layout:'fit',
 *     items: {
 *         title: 'Inner Panel',
 *         html: 'This is the inner panel content',
 *         bodyPadding: 20,
 *         border: false
 *     },
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * <p>If the container has multiple items, all of the items will all be equally sized. This is usually
 * not desired, so to avoid this, place only a <b>single</b> item in the container. This sizing
 * of all items can be used to provide a background <i>image</i> (→<code>ext.Img</code>) that is "behind"
 * another item such as a <i>dataview</i> (→<code>ext.view.DataView</code>) if you also absolutely position the items.</p>
 * @see ext.container.Container#layout
 * @see ext.Img
 * @see ext.view.DataView
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Fit.html Original Ext JS documentation of 'Ext.layout.container.Fit'
 */
public class FitLayout extends ContainerLayout {
  /**
   * @param config @inheritDoc
   */
  public function FitLayout(config:FitLayout = null) {
    super();
  }

  [ExtConfig]
  /**
   * An optional extra CSS class that will be added to the container. This can be useful for
   * adding customized styles to the container or any of its children using standard CSS
   * rules. See →<code>ext.Component</code>.→<code>ext.Component.componentCls</code> also.
   * @default Ext.baseCSSPrefix + 'fit-item'
   * @see ext.Component
   * @see ext.Component#componentCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Fit.html#cfg-itemCls Original Ext JS documentation of 'itemCls'
   */
  override public native function get itemCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set itemCls(value:String):void;
}
}