package ext.layout.container {

[Native("Ext.layout.container.Form", require)]
/**
 * This is a layout that will render form Fields, one under the other all stretched to the Container
 * width.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.Panel', {
 *     width: 500,
 *     height: 300,
 *     title: "FormLayout Panel",
 *     layout: 'form',
 *     renderTo: Ext.getBody(),
 *     bodyPadding: 5,
 *     defaultType: 'textfield',
 *     items: [{
 *        fieldLabel: 'First Name',
 *         name: 'first',
 *         allowBlank:false
 *     },{
 *         fieldLabel: 'Last Name',
 *         name: 'last'
 *     },{
 *         fieldLabel: 'Company',
 *         name: 'company'
 *     }, {
 *         fieldLabel: 'Email',
 *         name: 'email',
 *         vtype:'email'
 *     }, {
 *         fieldLabel: 'DOB',
 *         name: 'dob',
 *         xtype: 'datefield'
 *     }, {
 *         fieldLabel: 'Age',
 *         name: 'age',
 *         xtype: 'numberfield',
 *         minValue: 0,
 *         maxValue: 100
 *     }, {
 *         xtype: 'timefield',
 *         fieldLabel: 'Time',
 *         name: 'time',
 *         minValue: '8:00am',
 *         maxValue: '6:00pm'
 *     }]
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Form.html Original Ext JS documentation of 'Ext.layout.container.Form'
 */
public class FormLayout extends AutoLayout {
  /**
   * @param config @inheritDoc
   */
  public function FormLayout(config:FormLayout = null) {
    super();
  }

  [ExtConfig]
  /**
   * The amount of space, in pixels, to use between the items. Defaults to the value
   * inherited from the theme's stylesheet as configured by
   * <i>$form-item-margin-bottom</i> (→<code>ext.form.Labelable.style:$form-item-margin-bottom</code>).
   * @see ext.form.Labelable#style:$form-item-margin-bottom
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Form.html#cfg-itemSpacing Original Ext JS documentation of 'itemSpacing'
   */
  public native function get itemSpacing():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set itemSpacing(value:Number):void;

  [ExtConfig]
  /**
   * The width of the labels. This can be either a number in pixels, or a valid CSS
   * "width" style, e.g. <code>'100px'</code>, or <code>'30%'</code>. When configured, all labels will assume
   * this width, and any →<code>ext.form.Labelable.labelWidth</code> specified
   * on the items will be ignored.
   * <p>The default behavior of this layout when no no labelWidth is specified is to size
   * the labels to the text-width of the label with the longest text.</p>
   * @see ext.form.Labelable#labelWidth
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Form.html#cfg-labelWidth Original Ext JS documentation of 'labelWidth'
   */
  public native function get labelWidth():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelWidth(value:*):void;
}
}