package ext.layout.container {

[Native("Ext.layout.container.HBox", require)]
/**
 * A layout that arranges items horizontally across a
 * →<code>ext.container.Container</code>. This layout optionally divides available
 * horizontal space between child →<code>ext.container.Container.items</code>
 * containing a numeric →<code>ext.Component.flex</code> configuration.
 * <p>This layout may be used to set the heights or vertical position of child items
 * by configuring it with the →<code>align</code> option. The horizontal position of the
 * child items may be set using the →<code>pack</code> config.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.Panel', {
 *     width: 500,
 *     height: 300,
 *     title: "HBoxLayout Panel",
 *     layout: {
 *         type: 'hbox',
 *         align: 'stretch'
 *     },
 *     renderTo: document.body,
 *     items: [{
 *         xtype: 'panel',
 *         title: 'Inner Panel One',
 *         flex: 2
 *     },{
 *         xtype: 'panel',
 *         title: 'Inner Panel Two',
 *         flex: 1
 *     },{
 *         xtype: 'panel',
 *         title: 'Inner Panel Three',
 *         flex: 1
 *     }]
 * });
 * </pre>
 * <p>The following example may be used to view the outcomes when combining the <code>→align</code> and
 * <code>→pack</code> configs:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *     xtype: 'panel',
 *     renderTo: Ext.getBody(),
 *     height: 400,
 *     width: 520,
 *     defaultListenerScope: true,
 *     layout: 'hbox',
 *     defaultType: 'button',
 *     items: [{
 *         text: 'One'
 *     }, {
 *         text: 'Two'
 *     }, {
 *         text: 'Three'
 *     }],
 *     dockedItems: [{
 *         xtype: 'toolbar',
 *         dock: 'top',
 *         items: [{
 *             xtype: 'buttongroup',
 *             title: 'align',
 *             layout: 'fit',
 *             items: [{
 *                 xtype: 'segmentedbutton',
 *                 margin: 10,
 *                 allowDepress: true,
 *                 defaults: {
 *                     configType: 'align'  // custom config used in this example
 *                 },
 *                 items: [{
 *                     text: 'begin'
 *                 }, {
 *                     text: 'middle'
 *                 }, {
 *                     text: 'end'
 *                 }, {
 *                     text: 'stretch'
 *                 }, {
 *                     text: 'stretchmax'
 *                 }],
 *                 listeners: {
 *                     toggle: 'onToggle'
 *                 }
 *             }]
 *         }, '-&gt;', {
 *             xtype: 'buttongroup',
 *             title: 'pack',
 * 			   layout: 'fit',
 *             items: [{
 *                 xtype: 'segmentedbutton',
 *                 margin: 10,
 *                 allowDepress: true,
 *                 defaults: {
 *                     configType: 'pack'  // custom config used in this example
 *                 },
 *                 items: [{
 *                     text: 'start'
 *                 }, {
 *                     text: 'center'
 *                 }, {
 *                     text: 'end'
 *                 }],
 *                 listeners: {
 *                     toggle: 'onToggle'
 *                 }
 *             }]
 *         }]
 *     }],
 *
 *     onToggle: function (group, button, isPressed) {
 *         var cfg = {};
 *
 *         cfg[button.configType] = isPressed ? button.getText() : null;
 *         this.setLayout(cfg);
 *     }
 * });
 * </pre>
 * @see ext.container.Container
 * @see ext.container.Container#items
 * @see ext.Component#flex
 * @see #align
 * @see #pack
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.HBox.html Original Ext JS documentation of 'Ext.layout.container.HBox'
 */
public class HBoxLayout extends BoxLayout {
  /**
   * @param config @inheritDoc
   */
  public function HBoxLayout(config:HBoxLayout = null) {
    super();
  }
}
}