package ext.layout.container {

[Native("Ext.layout.container.Table", require)]
/**
 * This layout allows you to easily render content into an HTML table. The total number of columns
 * can be specified, and rowspan and colspan can be used to create complex layouts within the table.
 * This class is intended to be extended or created via the <code>layout: {type: 'table'}</code>
 * →<code>ext.container.Container.layout</code> config, and should generally not need to be created
 * directly via the new keyword.
 * <p>Note that when creating a layout via config, the layout-specific config properties must be passed
 * in via the →<code>ext.container.Container.layout</code> object which will then be applied internally
 * to the layout. In the case of TableLayout, the only valid layout config properties are
 * →<code>columns</code> and →<code>tableAttrs</code>. However, the items added to a TableLayout can supply
 * the following table-specific config properties:</p>
 * <ul>
 * <li><b>rowspan</b> Applied to the table cell containing the item.</li>
 * <li><b>colspan</b> Applied to the table cell containing the item.</li>
 * <li><b>cellCls</b> A CSS class name added to the table cell containing the item.</li>
 * </ul>
 * <p>The basic concept of building up a TableLayout is conceptually very similar to building up
 * a standard HTML table. You simply add each panel (or "cell") that you want to include along
 * with any span attributes specified as the special config properties of rowspan and colspan
 * which work exactly like their HTML counterparts. Rather than explicitly creating and nesting rows
 * and columns as you would in HTML, you simply specify the total column count in the layout config
 * and start adding panels in their natural order from left to right, top to bottom. The layout will
 * automatically figure out, based on the column count, rowspans and colspans, how to position each
 * panel within the table. Just like with HTML tables, your rowspans and colspans must add up
 * correctly in your overall layout or you'll end up with missing and/or extra cells!
 * Example usage:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.panel.Panel', {
 *     title: 'Table Layout',
 *     width: 300,
 *     height: 150,
 *     layout: {
 *         type: 'table',
 *         // The total column count must be specified here
 *         columns: 3
 *     },
 *     defaults: {
 *         // applied to each contained panel
 *         bodyStyle: 'padding:20px'
 *     },
 *     items: [{
 *         html: 'Cell A content',
 *         rowspan: 2
 *     },{
 *         html: 'Cell B content',
 *         colspan: 2
 *     },{
 *         html: 'Cell C content',
 *         cellCls: 'highlight'
 *     },{
 *         html: 'Cell D content'
 *     }],
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * @see ext.container.Container#layout
 * @see #columns
 * @see #tableAttrs
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Table.html Original Ext JS documentation of 'Ext.layout.container.Table'
 */
public class TableLayout extends ContainerLayout {
  /**
   * @param config @inheritDoc
   */
  public function TableLayout(config:TableLayout = null) {
    super();
  }

  [ExtConfig]
  /**
   * The total number of columns to create in the table for this layout. If not specified,
   * all Components added to this layout will be rendered into a single row using one column
   * per Component.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Table.html#cfg-columns Original Ext JS documentation of 'columns'
   */
  public native function get columns():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set columns(value:Number):void;

  [ExtConfig]
  /**
   * An object containing properties which are added to the →<code>ext.dom.DomHelper</code>
   * specification used to create the layout's <code>&lt;table&gt;</code> element. Example:
   * <pre>
   * {
   *     xtype: 'panel',
   *     layout: {
   *         type: 'table',
   *         columns: 3,
   *         tableAttrs: {
   *             style: {
   *                 width: '100%'
   *             }
   *         }
   *     }
   * }
   * </pre>
   * @see ext.dom.#DomHelper ext.dom.DomHelper
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Table.html#cfg-tableAttrs Original Ext JS documentation of 'tableAttrs'
   */
  public native function get tableAttrs():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set tableAttrs(value:Object):void;

  [ExtConfig]
  /**
   * An object containing properties which are added to the →<code>ext.dom.DomHelper</code>
   * specification used to create the layout's <code>&lt;td&gt;</code> elements.
   * @see ext.dom.#DomHelper ext.dom.DomHelper
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Table.html#cfg-tdAttrs Original Ext JS documentation of 'tdAttrs'
   */
  public native function get tdAttrs():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set tdAttrs(value:Object):void;

  [ExtConfig]
  /**
   * An object containing properties which are added to the →<code>ext.dom.DomHelper</code>
   * specification used to create the layout's <code>&lt;tr&gt;</code> elements.
   * @see ext.dom.#DomHelper ext.dom.DomHelper
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.Table.html#cfg-trAttrs Original Ext JS documentation of 'trAttrs'
   */
  public native function get trAttrs():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set trAttrs(value:Object):void;
}
}