package ext.layout.container {

[Native("Ext.layout.container.VBox", require)]
/**
 * A layout that arranges items vertically down a
 * →<code>ext.container.Container</code>. This layout optionally divides available
 * vertical space between child →<code>ext.container.Container.items</code>
 * containing a numeric →<code>ext.Component.flex</code> configuration.
 * <p>This layout may also be used to set the widths of child items by configuring it with
 * the →<code>align</code> option. The vertical position of the child items may be set using
 * the →<code>pack</code> config.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.Panel', {
 *     width: 500,
 *     height: 400,
 *     title: "VBoxLayout Panel",
 *     layout: {
 *         type: 'vbox',
 *     },
 *     renderTo: document.body,
 *     items: [{
 *         xtype: 'panel',
 *         title: 'Inner Panel One',
 *         width: 250,
 *         flex: 2
 *     },
 *     {
 *         xtype: 'panel',
 *         title: 'Inner Panel Two',
 *         width: 250,
 *         flex: 4
 *     },
 *     {
 *         xtype: 'panel',
 *         title: 'Inner Panel Three',
 *         width: '50%',
 *         flex: 4
 *     }]
 * });
 * </pre>
 * <p>The following example may be used to view the outcomes when combining the <code>→align</code> and
 * <code>→pack</code> configs:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *     xtype: 'panel',
 *     renderTo: Ext.getBody(),
 *     height: 400,
 *     width: 520,
 *     defaultListenerScope: true,
 *     layout: 'vbox',
 *     defaultType: 'button',
 *     items: [{
 *         text: 'One'
 *     }, {
 *         text: 'Two'
 *     }, {
 *         text: 'Three'
 *     }],
 *
 *     dockedItems: [{
 *         xtype: 'toolbar',
 *         dock: 'top',
 *         items: [{
 *             xtype: 'buttongroup',
 *             title: 'align',
 *             layout: 'fit',
 *             items: [{
 *                 xtype: 'segmentedbutton',
 *                 margin: 10,
 *                 allowDepress: true,
 *                 defaults: {
 *                     configType: 'align'  // custom config used in this example
 *                 },
 *                 items: [{
 *                     text: 'begin'
 *                 }, {
 *                     text: 'middle'
 *                 }, {
 *                     text: 'end'
 *                 }, {
 *                     text: 'stretch'
 *                 }, {
 *                     text: 'stretchmax'
 *                 }],
 *                 listeners: {
 *                     toggle: 'onToggle'
 *                 }
 *             }]
 *         }, '-&gt;', {
 *             xtype: 'buttongroup',
 *             title: 'pack',
 *             layout: 'fit',
 *             items: [{
 *                 xtype: 'segmentedbutton',
 *                 margin: 10,
 *                 allowDepress: true,
 *                 defaults: {
 *                     configType: 'pack'  // custom config used in this example
 *                 },
 *                 items: [{
 *                     text: 'start'
 *                 }, {
 *                     text: 'center'
 *                 }, {
 *                     text: 'end'
 *                 }],
 *                 listeners: {
 *                     toggle: 'onToggle'
 *                 }
 *             }]
 *         }]
 *     }],
 *
 *     onToggle: function (group, button, isPressed) {
 *         var cfg = {};
 *
 *         cfg[button.configType] = isPressed ? button.getText() : null;
 *         this.setLayout(cfg);
 *     }
 * });
 * </pre>
 * @see ext.container.Container
 * @see ext.container.Container#items
 * @see ext.Component#flex
 * @see #align
 * @see #pack
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.VBox.html Original Ext JS documentation of 'Ext.layout.container.VBox'
 */
public class VBoxLayout extends BoxLayout {
  /**
   * @param config @inheritDoc
   */
  public function VBoxLayout(config:VBoxLayout = null) {
    super();
  }
}
}