package ext.layout.container.border {

[Native("Ext.layout.container.border.Region", require)]
/**
 * This override provides extra, border layout specific methods for <code>→ext.Component</code>. The
 * <code>→ext.layout.container.BorderLayout</code> class requires this override so that the added functions
 * are only included in a build when <code>border</code> layout is used.
 * @see ext.Component
 * @see ext.layout.container.BorderLayout
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.border.Region.html Original Ext JS documentation of 'Ext.layout.container.border.Region'
 */
public class BorderLayoutRegion {
  /**
   * This method changes the <code>region</code> config property for this border region. This is
   * only valid if this component is in a <code>border</code> layout (<code>→ext.layout.container.BorderLayout</code>).
   * @param region The new <code>region</code> value (<code>"north"</code>, <code>"south"</code>, <code>"east"</code> or
   * <code>"west"</code>).
   * @return The previous value of the <code>region</code> property.
   * @see ext.layout.container.BorderLayout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.border.Region.html#method-setRegion Original Ext JS documentation of 'setRegion'
   */
  public native function setRegion(region:String):String;

  /**
   * Sets the <code>weight</code> config property for this component. This is only valid if this
   * component is in a <code>border</code> layout (<code>→ext.layout.container.BorderLayout</code>).
   * @param weight The new <code>weight</code> value.
   * @return The previous value of the <code>weight</code> property.
   * @see ext.layout.container.BorderLayout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.layout.container.border.Region.html#method-setWeight Original Ext JS documentation of 'setWeight'
   */
  public native function setWeight(weight:Number):Number;
}
}