package ext.list {
import ext.Widget;
import ext.data.TreeModel;
import ext.dom.Element;
import ext.event.Event;

[Native("Ext.list.AbstractTreeItem", require)]
/**
 * The base class for all items in the <code>treelist (→ext.list.Tree)</code>.
 * @see ext.list.Tree
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html Original Ext JS documentation of 'Ext.list.AbstractTreeItem'
 */
public class AbstractTreeItem extends Widget {
  /**
   * @param config @inheritDoc
   */
  public function AbstractTreeItem(config:AbstractTreeItem = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> if this item is expandable. This value is taken from
   * the underlying →<code>node</code>.
   * @default false
   * @see #node
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#cfg-expandable Original Ext JS documentation of 'expandable'
   * @see #getExpandable()
   * @see #setExpandable()
   */
  public native function get expandable():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set expandable(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> if this item is expanded. This value is taken from
   * the underlying →<code>node</code>.
   * @default false
   * @see #node
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#cfg-expanded Original Ext JS documentation of 'expanded'
   * @see #getExpanded()
   * @see #setExpanded()
   */
  public native function get expanded():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set expanded(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * One or more space separated CSS classes to be applied to the icon element.
   * The CSS rule(s) applied should specify a background image to be used as the
   * icon.
   * <p>An example of specifying a custom icon class would be something like:</p>
   * <pre>
   * // specify the property in the config for the class:
   * iconCls: 'my-home-icon'
   *
   * // css rule specifying the background image to be used as the icon image:
   * .my-home-icon {
   *     background-image: url(../images/my-home-icon.gif) !important;
   * }
   * </pre>
   * <p>In addition to specifying your own classes, you can use the font icons
   * provided in the SDK using the following syntax:</p>
   * <pre>
   * // using Font Awesome
   * iconCls: 'x-fa fa-home'
   *
   * // using Pictos
   * iconCls: 'pictos pictos-home'
   * </pre>
   * <p>Depending on the theme you're using, you may need include the font icon
   * packages in your application in order to use the icons included in the
   * SDK. For more information see:</p>
   * <ul>
   * <li><a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/">Font Awesome icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/font_ext.html">Pictos icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/theming.html">Theming Guide</a>
   * <b>Note:</b> This value is taken from the underlying →<code>node</code>.</li>
   * </ul>
   * @default ''
   * @see #node
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#cfg-iconCls Original Ext JS documentation of 'iconCls'
   * @see #getIconCls()
   * @see #setIconCls()
   */
  public native function get iconCls():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set iconCls(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The property from the →<code>node</code> to map for the →<code>iconCls</code> config.
   * @default 'iconCls'
   * @see #node
   * @see #iconCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#cfg-iconClsProperty Original Ext JS documentation of 'iconClsProperty'
   * @see #getIconClsProperty()
   * @see #setIconClsProperty()
   */
  public native function get iconClsProperty():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set iconClsProperty(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> if this item is a leaf. This value is taken from
   * the underlying →<code>node</code>.
   * @default true
   * @see #node
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#cfg-leaf Original Ext JS documentation of 'leaf'
   * @see #getLeaf()
   * @see #setLeaf()
   */
  public native function get leaf():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set leaf(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> if this item is currently loading data. This value is taken from
   * the underlying →<code>node</code>.
   * @default false
   * @see #node
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#cfg-loading Original Ext JS documentation of 'loading'
   * @see #getLoading()
   * @see #setLoading()
   */
  public native function get loading():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set loading(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The backing node for this item.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#cfg-node Original Ext JS documentation of 'node'
   * @see #getNode()
   * @see #setNode()
   */
  public native function get node():TreeModel;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set node(value:TreeModel):void;

  [ExtConfig]
  [Bindable]
  /**
   * One of three possible values...
   * <ul>
   * <li>0 if mouse is not over this item or any of its descendants.</li>
   * <li>1 if mouse is not over this item but is over one of this item's descendants.</li>
   * <li>2 if mouse is directly over this item.</li>
   * </ul>
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#cfg-over Original Ext JS documentation of 'over'
   * @see #getOver()
   * @see #setOver()
   */
  public native function get over():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set over(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The owning list for this container.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#cfg-owner Original Ext JS documentation of 'owner'
   * @see #getOwner()
   * @see #setOwner()
   */
  public native function get owner():Tree;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set owner(value:Tree):void;

  [ExtConfig]
  [Bindable]
  /**
   * The parent item for this item.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#cfg-parentItem Original Ext JS documentation of 'parentItem'
   * @see #getParentItem()
   * @see #setParentItem()
   */
  public native function get parentItem():AbstractTreeItem;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set parentItem(value:AbstractTreeItem):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> if this is the selected item in the tree.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#cfg-selected Original Ext JS documentation of 'selected'
   * @see #getSelected()
   * @see #setSelected()
   */
  public native function get selected():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set selected(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> if this item contains the →<code>selected</code> item in the tree.
   * @default false
   * @see #selected
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#cfg-selectedParent Original Ext JS documentation of 'selectedParent'
   * @see #getSelectedParent()
   * @see #setSelectedParent()
   */
  public native function get selectedParent():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set selectedParent(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The text for this item. This value is taken from
   * the underlying →<code>node</code>.
   * @default ''
   * @see #node
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#cfg-text Original Ext JS documentation of 'text'
   * @see #getText()
   * @see #setText()
   */
  public native function get text():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set text(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The property from the →<code>node</code> to map for the →<code>text</code> config.
   * @default 'text'
   * @see #node
   * @see #text
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#cfg-textProperty Original Ext JS documentation of 'textProperty'
   * @see #getTextProperty()
   * @see #setTextProperty()
   */
  public native function get textProperty():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set textProperty(value:String):void;

  /**
   * Collapse this item. Does nothing if already collapsed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#method-collapse Original Ext JS documentation of 'collapse'
   */
  public native function collapse():void;

  /**
   * Destroys the Widget. This method should not be overridden in custom Widgets,
   * because it sets the flags and does final cleanup that must go last. Instead,
   * override →<code>doDestroy()</code> method to add functionality at destruction time.
   * @see #doDestroy()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#method-destroy Original Ext JS documentation of 'destroy'
   */
  override public native function destroy(...params):void;

  /**
   * Expand this item. Does nothing if already expanded.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#method-expand Original Ext JS documentation of 'expand'
   */
  public native function expand():void;

  /**
   * Returns the value of <code>expandable</code>.
   * @see #expandable
   */
  public native function getExpandable():Boolean;

  /**
   * Returns the value of <code>expanded</code>.
   * @see #expanded
   */
  public native function getExpanded():Boolean;

  /**
   * Returns the value of <code>iconCls</code>.
   * @see #iconCls
   */
  public native function getIconCls():String;

  /**
   * Returns the value of <code>iconClsProperty</code>.
   * @see #iconClsProperty
   */
  public native function getIconClsProperty():String;

  /**
   * Returns the value of <code>leaf</code>.
   * @see #leaf
   */
  public native function getLeaf():Boolean;

  /**
   * Returns the value of <code>loading</code>.
   * @see #loading
   */
  public native function getLoading():Boolean;

  /**
   * Returns the value of <code>node</code>.
   * @see #node
   */
  public native function getNode():TreeModel;

  /**
   * Returns the value of <code>over</code>.
   * @see #over
   */
  public native function getOver():Number;

  /**
   * Returns the value of <code>owner</code>.
   * @see #owner
   */
  public native function getOwner():Tree;

  /**
   * Returns the value of <code>parentItem</code>.
   * @see #parentItem
   */
  public native function getParentItem():AbstractTreeItem;

  /**
   * Returns the value of <code>selected</code>.
   * @see #selected
   */
  public native function getSelected():Boolean;

  /**
   * Returns the value of <code>selectedParent</code>.
   * @see #selectedParent
   */
  public native function getSelectedParent():Boolean;

  /**
   * Returns the value of <code>text</code>.
   * @see #text
   */
  public native function getText():String;

  /**
   * Returns the value of <code>textProperty</code>.
   * @see #textProperty
   */
  public native function getTextProperty():String;

  /**
   * Gets the element to be used for the tree when it is in
   * →<code>ext.list.Tree.micro</code> mode.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @return The element.
   * @see ext.list.Tree#micro
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#method-getToolElement Original Ext JS documentation of 'getToolElement'
   */
  protected native function getToolElement():Element;

  /**
   * Append a new child item to the DOM.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param item The item to insert.
   * @param refItem The item the node is to
   * be inserted before. <code>null</code> if the item is to be added to the end.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#method-insertItem Original Ext JS documentation of 'insertItem'
   */
  protected native function insertItem(item:AbstractTreeItem, refItem:AbstractTreeItem):void;

  /**
   * Check if the current item is expanded.
   * @return <code>true</code> if this item is expanded.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#method-isExpanded Original Ext JS documentation of 'isExpanded'
   */
  public native function isExpanded():Boolean;

  /**
   * Checks whether the event is an event that should select this node.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param e The event object.
   * @return <code>true</code> if the event should select this node.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#method-isSelectionEvent Original Ext JS documentation of 'isSelectionEvent'
   */
  protected native function isSelectionEvent(e:Event):Boolean;

  /**
   * Checks whether the event is an event that should toggle the expand/collapse state.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param e The event object.
   * @return <code>true</code> if the event should toggle the expand/collapsed state.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#method-isToggleEvent Original Ext JS documentation of 'isToggleEvent'
   */
  protected native function isToggleEvent(e:Event):Boolean;

  /**
   * Handle this node being collapsed.
   * @param node The node being collapsed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#method-nodeCollapse Original Ext JS documentation of 'nodeCollapse'
   */
  protected native function nodeCollapse(node:TreeModel, collapsingForExpand:* = undefined):void;

  /**
   * Handle this node being expanded.
   * @param node The node being expanded.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#method-nodeExpand Original Ext JS documentation of 'nodeExpand'
   */
  protected native function nodeExpand(node:TreeModel):void;

  /**
   * Handle a node being inserted as a child of this item.
   * @param node The node being inserted.
   * @param refNode The node that is to be inserted before. <code>null</code>
   * if this operation is an append.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#method-nodeInsert Original Ext JS documentation of 'nodeInsert'
   */
  protected native function nodeInsert(node:TreeModel, refNode:TreeModel):void;

  /**
   * Handle a node being removed as a child of this item.
   * @param node The node being removed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#method-nodeRemove Original Ext JS documentation of 'nodeRemove'
   */
  protected native function nodeRemove(node:TreeModel):void;

  /**
   * Handle this node having fields changed.
   * @param node The node.
   * @param modifiedFieldNames The modified field names, if known.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#method-nodeUpdate Original Ext JS documentation of 'nodeUpdate'
   */
  protected native function nodeUpdate(node:TreeModel, modifiedFieldNames:Array):void;

  /**
   * Handle a click on this item.
   * @param e The event
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#method-onClick Original Ext JS documentation of 'onClick'
   */
  protected native function onClick(e:Event):void;

  /**
   * Remove a child item from the DOM.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param item The item to remove.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.AbstractTreeItem.html#method-removeItem Original Ext JS documentation of 'removeItem'
   */
  protected native function removeItem(item:AbstractTreeItem):void;

  /**
   * Sets the value of <code>expandable</code>.
   * @param expandable The new value.
   * @see #expandable
   */
  public native function setExpandable(expandable:Boolean):void;

  /**
   * Sets the value of <code>expanded</code>.
   * @param expanded The new value.
   * @see #expanded
   */
  public native function setExpanded(expanded:Boolean):void;

  /**
   * Sets the value of <code>iconCls</code>.
   * @param iconCls The new value.
   * @see #iconCls
   */
  public native function setIconCls(iconCls:String):void;

  /**
   * Sets the value of <code>iconClsProperty</code>.
   * @param iconClsProperty The new value.
   * @see #iconClsProperty
   */
  public native function setIconClsProperty(iconClsProperty:String):void;

  /**
   * Sets the value of <code>leaf</code>.
   * @param leaf The new value.
   * @see #leaf
   */
  public native function setLeaf(leaf:Boolean):void;

  /**
   * Sets the value of <code>loading</code>.
   * @param loading The new value.
   * @see #loading
   */
  public native function setLoading(loading:Boolean):void;

  /**
   * Sets the value of <code>node</code>.
   * @param node The new value.
   * @see #node
   */
  public native function setNode(node:TreeModel):void;

  /**
   * Sets the value of <code>over</code>.
   * @param over The new value.
   * @see #over
   */
  public native function setOver(over:Number):void;

  /**
   * Sets the value of <code>owner</code>.
   * @param owner The new value.
   * @see #owner
   */
  public native function setOwner(owner:Tree):void;

  /**
   * Sets the value of <code>parentItem</code>.
   * @param parentItem The new value.
   * @see #parentItem
   */
  public native function setParentItem(parentItem:AbstractTreeItem):void;

  /**
   * Sets the value of <code>selected</code>.
   * @param selected The new value.
   * @see #selected
   */
  public native function setSelected(selected:Boolean):void;

  /**
   * Sets the value of <code>selectedParent</code>.
   * @param selectedParent The new value.
   * @see #selectedParent
   */
  public native function setSelectedParent(selectedParent:Boolean):void;

  /**
   * Sets the value of <code>text</code>.
   * @param text The new value.
   * @see #text
   */
  public native function setText(text:String):void;

  /**
   * Sets the value of <code>textProperty</code>.
   * @param textProperty The new value.
   * @see #textProperty
   */
  public native function setTextProperty(textProperty:String):void;
}
}