package ext.list {

[Native("Ext.list.RootTreeItem", require)]
/**
 * This class implements the top-level node in a <code>treelist (→ext.list.Tree)</code>. Unlike
 * other nodes, this item is only a container for other items. It does not correspond to
 * a data record.
 * @see ext.list.Tree
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.RootTreeItem.html Original Ext JS documentation of 'Ext.list.RootTreeItem'
 */
public class RootTreeItem extends AbstractTreeItem {
  /**
   * @inheritDoc
   */
  public function RootTreeItem(config:AbstractTreeItem = null) {
    super();
  }

  /**
   * This property is <code>true</code> to allow type checking for this or derived class.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.RootTreeItem.html#property-isRootListItem Original Ext JS documentation of 'isRootListItem'
   */
  public native function get isRootListItem():Boolean;
}
}