package ext.list {
import ext.Widget;
import ext.data.TreeModel;
import ext.mixin.IItemRipplerMixin;

[Native("Ext.list.Tree", require)]
/**
 * @see ext.list.events.Tree_infoEvent.ITEM_CLICK
 * @eventType ext.list.events.Tree_infoEvent.ITEM_CLICK
 */
[Event(name='onItemClick', type='ext.list.events.Tree_infoEvent')]
/**
 * @see ext.list.events.Tree_recordEvent.SELECTION_CHANGE
 * @eventType ext.list.events.Tree_recordEvent.SELECTION_CHANGE
 */
[Event(name='onSelectionChange', type='ext.list.events.Tree_recordEvent')]
/**
 * A lightweight component to display data in a simple tree structure using a
 * →<code>ext.data.TreeStore</code>.
 * <p>Simple Treelist using inline data:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *     xtype: 'treelist',
 *     store: {
 *         root: {
 *         expanded: true,
 *             children: [{
 *                 text: 'detention',
 *                 leaf: true,
 *                 iconCls: 'x-fa fa-frown-o'
 *             }, {
 *                 text: 'homework',
 *                 expanded: true,
 *                 iconCls: 'x-fa fa-folder',
 *                 children: [{
 *                     text: 'book report',
 *                     leaf: true,
 *                     iconCls: 'x-fa fa-book'
 *                 }, {
 *                     text: 'algebra',
 *                     leaf: true,
 *                     iconCls: 'x-fa fa-graduation-cap'
 *                 }]
 *             }, {
 *                 text: 'buy lottery tickets',
 *                 leaf: true,
 *                 iconCls: 'x-fa fa-usd'
 *             }]
 *         }
 *     },
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * <p>To collapse the Treelist for use in a smaller navigation view see →<code>micro</code>.
 * Parent Treelist node expansion may be refined using the →<code>singleExpand</code> and
 * →<code>expanderOnly</code> config options. Treelist nodes will be selected when clicked /
 * tapped excluding clicks on the expander unless →<code>selectOnExpander</code> is set to
 * <code>true</code>.</p>
 * @see ext.data.TreeStore
 * @see #micro
 * @see #singleExpand
 * @see #expanderOnly
 * @see #selectOnExpander
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.Tree.html Original Ext JS documentation of 'Ext.list.Tree'
 */
public class Tree extends Widget implements IItemRipplerMixin {
  /**
   * @param config @inheritDoc
   */
  public function Tree(config:Tree = null) {
    super();
  }

  /**
   * This property is used to determine the property of a <code>→bind</code> config that is just
   * the value. For example, if <code>defaultBindProperty="value"</code>, then this shorthand
   * <code>→bind</code> config:
   * <pre>
   *  bind: '{name}'
   * </pre>
   * <p>Is equivalent to this object form:</p>
   * <pre>
   *  bind: {
   *      value: '{name}'
   *  }
   * </pre>
   * <p>The <code>→defaultBindProperty</code> is set to "value" for form fields and to "store" for
   * grids and trees.</p>
   * @default 'store'
   * @see #bind
   * @see #defaultBindProperty
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.Tree.html#property-defaultBindProperty Original Ext JS documentation of 'defaultBindProperty'
   */
  override public native function get defaultBindProperty():String;

  /**
   * @private
   */
  override public native function set defaultBindProperty(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The default configuration for the widgets created for tree items.
   * @default {
   *     xtype: 'treelistitem'
   * }
   * <ul>
   * <li><code>xtype:String</code> (default = <code>"treelistitem"</code>) —
   * The type of item to create. By default, items are
   * <code>treelistitem (→ext.list.TreeItem)</code> instances. This can be customized but this
   * <code>xtype</code> must reference a class that ultimately derives from the
   * <code>→ext.list.AbstractTreeItem</code> base class.
   * </li>
   * </ul>
   * @see ext.list.TreeItem
   * @see ext.list.AbstractTreeItem
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.Tree.html#cfg-defaults Original Ext JS documentation of 'defaults'
   * @see #getDefaults()
   * @see #setDefaults()
   */
  public native function get defaults():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set defaults(value:Object):void;

  /**
   * A configuration object for Ext.Element.create() that is used to create the Element
   * template. Subclasses should avoid overriding this property and instead add elements
   * using →<code>template</code>.
   * <p>Supports all the standard options of a Ext.Element.create() config and adds 3
   * additional options:</p>
   * <ol>
   * <li>
   * <p><code>→reference</code> - this option specifies a name for Element references. These
   * references names become properties of the Widget instance and refer to Ext.Element
   * instances that were created using the template:</p>
   * <pre>
   *   element: {
   *       reference: 'element',
   *       children: [{
   *           reference: 'innerElement'
   *       }]
   *   }
   * </pre>
   * </li>
   * </ol>
   * <p>After construction of a widget the reference elements are accessible as follows:</p>
   * <pre>
   * var foo = new FooWidget(),
   *     innerEl = foo.innerElement; // an Ext.Element that wraps the innerElement
   * </pre>
   * <p>The reference attribute is optional, but all Widgets must have a <code>'element'</code>
   * reference on some element within the template (usually the outermost one).</p>
   * <ol start="2">
   * <li>
   * <p><code>→listeners</code> - a standard listeners object as specified by →<code>ext.mixin.Observable</code>.</p>
   * <pre>
   *   element: {
   *       reference: 'element',
   *       listeners: {
   *           click: 'onClick'
   *       },
   *       children: [{
   *           reference: 'innerElement',
   *           listeners: {
   *               click: 'onInnerClick'
   *           }
   *       }]
   *   }
   * </pre>
   * </li>
   * </ol>
   * <p>Since listeners cannot be attached without an Ext.Element reference the <code>→reference</code>
   * property MUST be specified in order to use <code>→listeners</code>.</p>
   * <p>The Widget instance is used as the scope for all listeners specified in this way,
   * so it is invalid to use the <code>scope</code> option in the <code>→listeners</code> config since it will
   * always be overwritten using <code>this</code>.</p>
   * <ol start="3">
   * <li><code>uiCls</code> - a suffix to be appended to the ui-specific CSS class for each <code>→ui</code>
   * for this widget. These ui classes are constructed by appending the <code>→ui</code> to each
   * <code>→classCls</code> or <code>→baseCls</code> for the widget. As such, <code>uiCls</code> should
   * never be used on the main <code>→element</code> reference, as its <code>uiCls</code> is computed automatically.</li>
   * </ol>
   * <p>For example, assume a widget is defined with a <code>→ui</code> of <code>'alt action'</code> and a
   * <code>uiCls</code> of <code>'inner-el'</code> on its <code>innerElement</code> reference element:</p>
   * <pre>
   *      Ext.define('Doodad', {
   *          extend: 'Ext.Widget',
   *          xtype: 'doodad',
   *
   *          classCls: 'x-doodad',
   *
   *          ui: 'alt action',
   *
   *          element: {
   *              reference: 'element',
   *
   *              children: [{
   *                  reference: 'innerElement',
   *                  cls: 'x-inner-el',
   *                  uiCls: 'inner-el'
   *              }]
   *          }
   *      });
   * </pre>
   * <p>This would result in the following markup when rendered:</p>
   * <pre>
   * &lt;div class="x-doodad x-doodad-alt x-doodad-action"&gt;
   *     &lt;div class="x-inner-el x-doodad-inner-el x-doodad-alt-inner-el x-doodad-action-inner-el"&gt;&lt;/div&gt;
   * &lt;/div&gt;
   * </pre>
   * <p>These additional classes can be used to style the reference element for a particular
   * ui; however, use of <code>uiCls</code> is not typically necessary or recommended. Reference
   * elements should usually be styled using simple descendant selectors:</p>
   * <pre>
   * .x-doodad-alt .x-inner-el {
   *     color: red;
   * }
   * </pre>
   * <p>When there is a possibility that widgets can be nested it is best to use direct
   * child selectors to avoid the possibility of selecting all descendants instead
   * of just the reference element for the intended widget:</p>
   * <pre>
   * .x-doodad-alt &gt; .x-inner-el {
   *     color: red;
   * }
   * </pre>
   * <p>Only use <code>uiCls</code> when there is a possibility of nesting, AND there may be a variable
   * number of elements between the main <code>→element</code> and the reference element in question.
   * For example, Ext.Container with docked items has a different number of elements
   * in between its <code>→element</code> and its <code>bodyElement</code> than a Container without docked items
   * because of the wrapping elements that are dynamically added to support docking.
   * To ensure it does not style all descendants it must use a <code>uiCls</code> to style its
   * <code>bodyElement</code>:</p>
   * <pre>
   * .x-container-alt-body-el {
   *     background: #fff;
   * }
   * </pre>
   * <p>Note that when <code>uiCls</code> is specified it also adds a class name that does not contain
   * the <code>→ui</code> using just the <code>→classCls</code> and/or <code>→baseCls</code> as the prefix. This class name
   * can be used for base-level styling that does not relate to any particular UI:</p>
   * <pre>
   * .x-container-body-el {
   *     position: relative;
   * }
   * </pre>
   * @default {
   *     reference: 'element',
   *     cls: Ext.baseCSSPrefix + 'treelist ' + Ext.baseCSSPrefix + 'unselectable',
   *     listeners: {
   *         click: 'onClick',
   *         touchstart: 'onTouchStart',
   *         touchend: 'onTouchEnd',
   *         mouseenter: 'onMouseEnter',
   *         mouseleave: 'onMouseLeave',
   *         mouseover: 'onMouseOver'
   *     },
   *     children: [
   *         {
   *             reference: 'toolsElement',
   *             cls: Ext.baseCSSPrefix + 'treelist-toolstrip',
   *             listeners: {
   *                 click: 'onToolStripClick',
   *                 mouseover: 'onToolStripMouseOver'
   *             }
   *         }
   *     ]
   * }
   * @see #template
   * @see #reference
   * @see #listeners
   * @see ext.mixin.Observable
   * @see #ui
   * @see #classCls
   * @see #baseCls
   * @see #element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.Tree.html#property-element Original Ext JS documentation of 'element'
   */
  override public native function get element():Object;

  /**
   * @private
   */
  override public native function set element(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to display the expander to the left of the item text.
   * <code>false</code> to display the expander to the right of the item text.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.Tree.html#cfg-expanderFirst Original Ext JS documentation of 'expanderFirst'
   * @see #getExpanderFirst()
   * @see #setExpanderFirst()
   */
  public native function get expanderFirst():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set expanderFirst(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to expand only on the click of the expander element. Setting this to
   * <code>false</code> will allow expansion on click of any part of the element.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.Tree.html#cfg-expanderOnly Original Ext JS documentation of 'expanderOnly'
   * @see #getExpanderOnly()
   * @see #setExpanderOnly()
   */
  public native function get expanderOnly():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set expanderOnly(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to allow the popout to show on leaf items on click/tap. This is the same popout
   * (menu) non-leaf items show their child items in. <code>false</code> to prevent the popout
   * from showing for leaf items.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.Tree.html#cfg-floatLeafItems Original Ext JS documentation of 'floatLeafItems'
   * @see #getFloatLeafItems()
   * @see #setFloatLeafItems()
   */
  public native function get floatLeafItems():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set floatLeafItems(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Set as <code>true</code> to highlight all items on the path to the currently selected
   * node.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.Tree.html#cfg-highlightPath Original Ext JS documentation of 'highlightPath'
   * @see #getHighlightPath()
   * @see #setHighlightPath()
   */
  public native function get highlightPath():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set highlightPath(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The number of pixels to offset each level of tree nodes.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.Tree.html#cfg-indent Original Ext JS documentation of 'indent'
   * @see #getIndent()
   * @see #setIndent()
   */
  public native function get indent():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set indent(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * @default null
   * @since 6.5.0
   * <ul>
   * <li><code>color:String</code> (optional) —
   * The background color of the ripple.
   * Default ripple →<code>ext.Widget.ripple</code> settings for each item in the data view
   * <p>For complex items, individual elements can suppress ripples by adding the
   * <code>x-no-ripple</code> class to disable rippling for a tree of elements.</p>
   * </li>
   * </ul>
   * @see ext.Widget#ripple
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.ItemRippler.html#cfg-itemRipple Original Ext JS documentation of 'itemRipple'
   * @see #getItemRipple()
   * @see #setItemRipple()
   */
  public native function get itemRipple():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set itemRipple(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * Set to <code>true</code> to collapse the Treelist UI to display only the
   * <i>icons</i> (→<code>ext.data.NodeInterface.iconCls</code>) of the root nodes. Hovering
   * the cursor (or tapping on a touch-enabled device) shows the child nodes beside
   * the icon.
   * @default false
   * @see ext.data.NodeInterface#iconCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.Tree.html#cfg-micro Original Ext JS documentation of 'micro'
   * @see #getMicro()
   * @see #setMicro()
   */
  public native function get micro():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set micro(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * One or more names of config properties that this component should publish
   * to its ViewModel. Generally speaking, only properties defined in a class config
   * block (including ancestor config blocks and mixins) are eligible for publishing
   * to the viewModel. Some components override this and publish their most useful
   * configs by default.
   * <p><b>Note:</b> We'll discuss publishing properties <b>not</b> found in the config block below.</p>
   * <p>Values determined to be invalid by component (often form fields and model validations)
   * will not be published to the ViewModel.</p>
   * <p>This config uses the <code>→reference</code> to determine the name of the data
   * object to place in the <code>ViewModel</code>. If <code>→reference</code> is not set then this config
   * is ignored.</p>
   * <p>By using this config and <code>→reference</code> you can bind configs between
   * components. For example:</p>
   * <pre>
   *  ...
   *      items: [{
   *          xtype: 'textfield',
   *          reference: 'somefield',  // component's name in the ViewModel
   *          publishes: 'value' // value is not published by default
   *      },{
   *          ...
   *      },{
   *          xtype: 'displayfield',
   *          bind: 'You have entered "{somefield.value}"'
   *      }]
   *  ...
   * </pre>
   * <p>Classes must provide this config as an Object:</p>
   * <pre>
   *  Ext.define('App.foo.Bar', {
   *      publishes: {
   *          foo: true,
   *          bar: true
   *      }
   *  });
   * </pre>
   * <p>This is required for the config system to properly merge values from derived
   * classes.</p>
   * <p>For instances this value can be specified as a value as show above or an array
   * or object as follows:</p>
   * <pre>
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: [
   *          'value',
   *          'rawValue',
   *          'dirty'
   *      ]
   *  }
   *
   *  // This achieves the same result as the above array form.
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: {
   *          value: true,
   *          rawValue: true,
   *          dirty: true
   *      }
   *  }
   * </pre>
   * <p>In some cases, users may want to publish a property to the viewModel that is not found
   * in a class config block. In these situations, you may utilize →<code>publishState()</code>
   * if the property has a setter method. Let's use
   * →<code>ext.form.Labelable.setFieldLabel()</code> as an example:</p>
   * <pre>
   *   setFieldLabel: function(fieldLabel) {
   *       this.callParent(arguments);
   *       this.publishState('fieldLabel', fieldLabel);
   *   }
   * </pre>
   * <p>With the above chunk of code, fieldLabel may now be published to the viewModel.</p>
   * @default {
   *     selection: 1
   * }
   * @see #reference
   * @see #publishState()
   * @see ext.form.Labelable#setFieldLabel()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.Tree.html#cfg-publishes Original Ext JS documentation of 'publishes'
   * @see #getPublishes()
   * @see #setPublishes()
   */
  override public native function get publishes():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set publishes(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to select the node when clicking the expander.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.Tree.html#cfg-selectOnExpander Original Ext JS documentation of 'selectOnExpander'
   * @see #getSelectOnExpander()
   * @see #setSelectOnExpander()
   */
  public native function get selectOnExpander():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set selectOnExpander(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The current selected node or its ID.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.Tree.html#cfg-selection Original Ext JS documentation of 'selection'
   * @see #getSelection()
   * @see #setSelection()
   */
  public native function get selection():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set selection(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> if only 1 node per branch may be expanded.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.Tree.html#cfg-singleExpand Original Ext JS documentation of 'singleExpand'
   * @see #getSingleExpand()
   * @see #setSingleExpand()
   */
  public native function get singleExpand():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set singleExpand(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The data source to which this component is bound.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.Tree.html#cfg-store Original Ext JS documentation of 'store'
   * @see #getStore()
   * @see #setStore()
   */
  public native function get store():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set store(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * This object holds a map of <code>config</code> properties that will update their binding
   * as they are modified. For example, <code>value</code> is a key added by form fields. The
   * form of this config is the same as <code>→publishes</code>.
   * <p>This config is defined so that updaters are not created and added for all
   * bound properties since most cannot be modified by the end-user and hence are
   * not appropriate for two-way binding.</p>
   * @default {
   *     selection: 1
   * }
   * @see #publishes
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.Tree.html#cfg-twoWayBindable Original Ext JS documentation of 'twoWayBindable'
   * @see #getTwoWayBindable()
   * @see #setTwoWayBindable()
   */
  override public native function get twoWayBindable():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set twoWayBindable(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The ui or uis to be used on this Component.
   * <p>When a ui is configured, CSS class names are added to the →<code>element</code>, created
   * by appending the ui name(s) to each →<code>classCls</code> and/or →<code>baseCls</code>.</p>
   * @default null
   * @see #element
   * @see #classCls
   * @see #baseCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.Tree.html#cfg-ui Original Ext JS documentation of 'ui'
   * @see #getUi()
   * @see #setUi()
   */
  override public native function get ui():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set ui(value:*):void;

  /**
   * Returns the value of <code>defaults</code>.
   * @see #defaults
   */
  public native function getDefaults():Object;

  /**
   * Returns the value of <code>expanderFirst</code>.
   * @see #expanderFirst
   */
  public native function getExpanderFirst():Boolean;

  /**
   * Returns the value of <code>expanderOnly</code>.
   * @see #expanderOnly
   */
  public native function getExpanderOnly():Boolean;

  /**
   * Returns the value of <code>floatLeafItems</code>.
   * @see #floatLeafItems
   */
  public native function getFloatLeafItems():Boolean;

  /**
   * Returns the value of <code>highlightPath</code>.
   * @see #highlightPath
   */
  public native function getHighlightPath():Boolean;

  /**
   * Returns the value of <code>indent</code>.
   * @see #indent
   */
  public native function getIndent():Number;

  /**
   * Get a child <i>item</i> (→<code>ext.list.AbstractTreeItem</code>) by node.
   * @param node The node.
   * @return The item. <code>null</code> if not found.
   * @see ext.list.AbstractTreeItem
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.Tree.html#method-getItem Original Ext JS documentation of 'getItem'
   */
  public native function getItem(node:TreeModel):AbstractTreeItem;

  /**
   * This method is called to populate and return a config object for new nodes. This
   * can be overridden by derived classes to manipulate properties or <code>xtype</code> of the
   * returned object. Upon return, the object is passed to <code>→ext.Ext.create()</code> and the
   * reference is stored as part of this tree.
   * <p>The base class implementation will apply any configured <code>→defaults</code> to the
   * object it returns.</p>
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param node The node backing the item.
   * @param parent The parent item. This is never <code>null</code> but
   * may be an instance of <code>→ext.list.RootTreeItem</code>.
   * @return The config object to pass to <code>→ext.Ext.create()</code> for the item.
   * @see ext.SExt#create() ext.Ext.create()
   * @see #defaults
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.Tree.html#method-getItemConfig Original Ext JS documentation of 'getItemConfig'
   * @see ext.list.RootTreeItem
   */
  public native function getItemConfig(node:TreeModel, parent:AbstractTreeItem):Object;

  /**
   * Returns the value of <code>itemRipple</code>.
   * @see #itemRipple
   */
  public native function getItemRipple():*;

  /**
   * Returns the value of <code>micro</code>.
   * @see #micro
   */
  public native function getMicro():Boolean;

  /**
   * Returns the value of <code>publishes</code>.
   * @see #publishes
   */
  override public native function getPublishes():*;

  /**
   * Returns the value of <code>selectOnExpander</code>.
   * @see #selectOnExpander
   */
  public native function getSelectOnExpander():Boolean;

  /**
   * Returns the value of <code>selection</code>.
   * @see #selection
   */
  public native function getSelection():*;

  /**
   * Returns the value of <code>singleExpand</code>.
   * @see #singleExpand
   */
  public native function getSingleExpand():Boolean;

  /**
   * Returns the value of <code>store</code>.
   * @see #store
   */
  public native function getStore():*;

  /**
   * Returns the value of <code>twoWayBindable</code>.
   * @see #twoWayBindable
   */
  override public native function getTwoWayBindable():*;

  /**
   * Returns the value of <code>ui</code>.
   * @see #ui
   */
  override public native function getUi():*;

  /**
   * Sets the value of <code>defaults</code>.
   * @param defaults The new value.
   * @see #defaults
   */
  public native function setDefaults(defaults:Object):void;

  /**
   * Sets the value of <code>expanderFirst</code>.
   * @param expanderFirst The new value.
   * @see #expanderFirst
   */
  public native function setExpanderFirst(expanderFirst:Boolean):void;

  /**
   * Sets the value of <code>expanderOnly</code>.
   * @param expanderOnly The new value.
   * @see #expanderOnly
   */
  public native function setExpanderOnly(expanderOnly:Boolean):void;

  /**
   * Sets the value of <code>floatLeafItems</code>.
   * @param floatLeafItems The new value.
   * @see #floatLeafItems
   */
  public native function setFloatLeafItems(floatLeafItems:Boolean):void;

  /**
   * Sets the value of <code>highlightPath</code>.
   * @param highlightPath The new value.
   * @see #highlightPath
   */
  public native function setHighlightPath(highlightPath:Boolean):void;

  /**
   * Sets the value of <code>indent</code>.
   * @param indent The new value.
   * @see #indent
   */
  public native function setIndent(indent:Number):void;

  /**
   * Sets the value of <code>itemRipple</code>.
   * @param itemRipple The new value.
   * @see #itemRipple
   */
  public native function setItemRipple(itemRipple:*):void;

  /**
   * Sets the value of <code>micro</code>.
   * @param micro The new value.
   * @see #micro
   */
  public native function setMicro(micro:Boolean):void;

  /**
   * Sets the value of <code>publishes</code>.
   * @param publishes The new value.
   * @see #publishes
   */
  override public native function setPublishes(publishes:*):void;

  /**
   * Sets the value of <code>selectOnExpander</code>.
   * @param selectOnExpander The new value.
   * @see #selectOnExpander
   */
  public native function setSelectOnExpander(selectOnExpander:Boolean):void;

  /**
   * Sets the value of <code>selection</code>.
   * @param selection The new value.
   * @see #selection
   */
  public native function setSelection(selection:*):void;

  /**
   * Sets the value of <code>singleExpand</code>.
   * @param singleExpand The new value.
   * @see #singleExpand
   */
  public native function setSingleExpand(singleExpand:Boolean):void;

  /**
   * Sets the value of <code>store</code>.
   * @param store The new value.
   * @see #store
   */
  public native function setStore(store:*):void;

  /**
   * Sets the value of <code>twoWayBindable</code>.
   * @param twoWayBindable The new value.
   * @see #twoWayBindable
   */
  override public native function setTwoWayBindable(twoWayBindable:*):void;

  /**
   * Sets the value of <code>ui</code>.
   * @param ui The new value.
   * @see #ui
   */
  override public native function setUi(ui:*):void;
}
}