package ext.list {

[Native("Ext.list.TreeItem", require)]
/**
 * The default implementation of the class used for <code>→ext.list.Tree</code>.
 * <p>This class can only be used in conjunction with →<code>ext.list.Tree</code>.</p>
 * @see ext.list.Tree
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.TreeItem.html Original Ext JS documentation of 'Ext.list.TreeItem'
 */
public class TreeItem extends AbstractTreeItem {
  /**
   * @param config @inheritDoc
   */
  public function TreeItem(config:TreeItem = null) {
    super();
  }

  /**
   * This property is <code>true</code> to allow type checking for this or derived class.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.TreeItem.html#property-isTreeListItem Original Ext JS documentation of 'isTreeListItem'
   */
  public native function get isTreeListItem():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * One or more CSS classes to add to the tree item's logical "row" element. This
   * element fills from left-to-right of the line.
   * @since 6.0.1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.TreeItem.html#cfg-rowCls Original Ext JS documentation of 'rowCls'
   * @see #getRowCls()
   * @see #setRowCls()
   */
  public native function get rowCls():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set rowCls(value:String):void;

  [ExtConfig]
  /**
   * The name of the associated record's field to map to the →<code>rowCls</code> config.
   * @default "rowCls"
   * @since 6.0.1
   * @see #rowCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.list.TreeItem.html#cfg-rowClsProperty Original Ext JS documentation of 'rowClsProperty'
   */
  public native function get rowClsProperty():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set rowClsProperty(value:String):void;

  /**
   * Returns the value of <code>rowCls</code>.
   * @see #rowCls
   */
  public native function getRowCls():String;

  /**
   * Sets the value of <code>rowCls</code>.
   * @param rowCls The new value.
   * @see #rowCls
   */
  public native function setRowCls(rowCls:String):void;
}
}