package ext.menu {

[Native("Ext.menu.CheckItem", require)]
/**
 * @see ext.menu.events.CheckItem_checkedEvent.BEFORE_CHECK_CHANGE
 * @eventType ext.menu.events.CheckItem_checkedEvent.BEFORE_CHECK_CHANGE
 */
[Event(name='onBeforeCheckChange', type='ext.menu.events.CheckItem_checkedEvent')]
/**
 * @see ext.menu.events.CheckItem_checkedEvent.CHECK_CHANGE
 * @eventType ext.menu.events.CheckItem_checkedEvent.CHECK_CHANGE
 */
[Event(name='onCheckChange', type='ext.menu.events.CheckItem_checkedEvent')]
/**
 * A menu item that contains a togglable checkbox by default, but that can also be a part
 * of a radio group.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.menu.Menu', {
 *     width: 100,
 *     height: 110,
 *     floating: false,  // usually you want this set to True (default)
 *     renderTo: Ext.getBody(),  // usually rendered by it's containing component
 *     items: [{
 *         xtype: 'menucheckitem',
 *         text: 'select all'
 *     }, {
 *         xtype: 'menucheckitem',
 *         text: 'select specific'
 *     }, {
 *         iconCls: 'add16',
 *         text: 'icon item'
 *     }, {
 *         text: 'regular item'
 *     }]
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.CheckItem.html Original Ext JS documentation of 'Ext.menu.CheckItem'
 */
public class CheckItem extends Item {
  /**
   * @param config @inheritDoc
   */
  public function CheckItem(config:CheckItem = null) {
    super();
  }

  [ExtConfig]
  /**
   * True to prevent the checked item from being toggled. Any submenu will still be accessible.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.CheckItem.html#cfg-checkChangeDisabled Original Ext JS documentation of 'checkChangeDisabled'
   */
  public native function get checkChangeDisabled():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set checkChangeDisabled(value:Boolean):void;

  [ExtConfig]
  /**
   * Alternative for the →<code>event:onCheckChange</code> event. Gets called with the same parameters.
   * @see #event:onCheckChange
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.CheckItem.html#cfg-checkHandler Original Ext JS documentation of 'checkHandler'
   */
  public native function get checkHandler():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set checkHandler(value:*):void;

  [ExtConfig]
  /**
   * True to render the menuitem initially checked.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.CheckItem.html#cfg-checked Original Ext JS documentation of 'checked'
   * @see #setChecked()
   */
  public native function get checked():Boolean;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set checked(value:Boolean):void;

  [ExtConfig]
  /**
   * The CSS class used by →<code>cls</code> to show the checked state.
   * Defaults to <code>Ext.baseCSSPrefix + 'menu-item-checked'</code>.
   * @default Ext.baseCSSPrefix + 'menu-item-checked'
   * @see #cls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.CheckItem.html#cfg-checkedCls Original Ext JS documentation of 'checkedCls'
   */
  public native function get checkedCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set checkedCls(value:String):void;

  [ExtConfig]
  /**
   * Name of a radio group that the item belongs.
   * <p>Specifying this option will turn check item into a radio item.</p>
   * <p>Note that the group name must be globally unique.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.CheckItem.html#cfg-group Original Ext JS documentation of 'group'
   */
  public native function get group():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set group(value:String):void;

  [ExtConfig]
  /**
   * The CSS class applied to this item's icon image to denote being a part of a radio group.
   * Defaults to <code>Ext.baseCSSClass + 'menu-group-icon'</code>.
   * Any specified →<code>iconCls</code> overrides this.
   * @default Ext.baseCSSPrefix + 'menu-group-icon'
   * @see #iconCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.CheckItem.html#cfg-groupCls Original Ext JS documentation of 'groupCls'
   */
  public native function get groupCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set groupCls(value:String):void;

  [ExtConfig]
  /**
   * Whether to not to hide the owning menu when this item is clicked.
   * Defaults to <code>false</code> for checkbox items, and to <code>true</code> for radio group items.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.CheckItem.html#cfg-hideOnClick Original Ext JS documentation of 'hideOnClick'
   */
  override public native function get hideOnClick():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set hideOnClick(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * One or more names of config properties that this component should publish
   * to its ViewModel. Generally speaking, only properties defined in a class config
   * block (including ancestor config blocks and mixins) are eligible for publishing
   * to the viewModel. Some components override this and publish their most useful
   * configs by default.
   * <p><b>Note:</b> We'll discuss publishing properties <b>not</b> found in the config block below.</p>
   * <p>Values determined to be invalid by component (often form fields and model validations)
   * will not be published to the ViewModel.</p>
   * <p>This config uses the <code>→reference</code> to determine the name of the data
   * object to place in the <code>ViewModel</code>. If <code>→reference</code> is not set then this config
   * is ignored.</p>
   * <p>By using this config and <code>→reference</code> you can bind configs between
   * components. For example:</p>
   * <pre>
   *  ...
   *      items: [{
   *          xtype: 'textfield',
   *          reference: 'somefield',  // component's name in the ViewModel
   *          publishes: 'value' // value is not published by default
   *      },{
   *          ...
   *      },{
   *          xtype: 'displayfield',
   *          bind: 'You have entered "{somefield.value}"'
   *      }]
   *  ...
   * </pre>
   * <p>Classes must provide this config as an Object:</p>
   * <pre>
   *  Ext.define('App.foo.Bar', {
   *      publishes: {
   *          foo: true,
   *          bar: true
   *      }
   *  });
   * </pre>
   * <p>This is required for the config system to properly merge values from derived
   * classes.</p>
   * <p>For instances this value can be specified as a value as show above or an array
   * or object as follows:</p>
   * <pre>
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: [
   *          'value',
   *          'rawValue',
   *          'dirty'
   *      ]
   *  }
   *
   *  // This achieves the same result as the above array form.
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: {
   *          value: true,
   *          rawValue: true,
   *          dirty: true
   *      }
   *  }
   * </pre>
   * <p>In some cases, users may want to publish a property to the viewModel that is not found
   * in a class config block. In these situations, you may utilize →<code>publishState()</code>
   * if the property has a setter method. Let's use
   * →<code>ext.form.Labelable.setFieldLabel()</code> as an example:</p>
   * <pre>
   *   setFieldLabel: function(fieldLabel) {
   *       this.callParent(arguments);
   *       this.publishState('fieldLabel', fieldLabel);
   *   }
   * </pre>
   * <p>With the above chunk of code, fieldLabel may now be published to the viewModel.</p>
   * @default 'checked'
   * @see #reference
   * @see #publishState()
   * @see ext.form.Labelable#setFieldLabel()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.CheckItem.html#cfg-publishes Original Ext JS documentation of 'publishes'
   * @see #getPublishes()
   * @see #setPublishes()
   */
  override public native function get publishes():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set publishes(value:*):void;

  [ExtConfig]
  /**
   * Scope for the →<code>checkHandler</code> callback.
   * @see #checkHandler
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.CheckItem.html#cfg-scope Original Ext JS documentation of 'scope'
   */
  public native function get scope():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set scope(value:Object):void;

  [ExtConfig]
  /**
   * Text to be announced by screen readers when a check item
   * submenu is focused.
   * @default '{0} submenu'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.CheckItem.html#cfg-submenuText Original Ext JS documentation of 'submenuText'
   */
  public native function get submenuText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set submenuText(value:String):void;

  [ExtConfig]
  /**
   * The CSS class used by →<code>cls</code> to show the unchecked state.
   * Defaults to <code>Ext.baseCSSPrefix + 'menu-item-unchecked'</code>.
   * @default Ext.baseCSSPrefix + 'menu-item-unchecked'
   * @see #cls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.CheckItem.html#cfg-uncheckedCls Original Ext JS documentation of 'uncheckedCls'
   */
  public native function get uncheckedCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set uncheckedCls(value:String):void;

  /**
   * Disables just the checkbox functionality of this menu Item. If this menu item has
   * a submenu, that submenu will still be accessible
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.CheckItem.html#method-disableCheckChange Original Ext JS documentation of 'disableCheckChange'
   */
  public native function disableCheckChange():void;

  /**
   * Re-enables the checkbox functionality of this menu item after having been
   * disabled by →<code>disableCheckChange()</code>
   * @see #disableCheckChange()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.CheckItem.html#method-enableCheckChange Original Ext JS documentation of 'enableCheckChange'
   */
  public native function enableCheckChange():void;

  /**
   * Returns the value of <code>publishes</code>.
   * @see #publishes
   */
  override public native function getPublishes():*;

  /**
   * Sets the checked state of the item
   * @param checked True to check, false to un-check
   * @param suppressEvents True to prevent firing the checkchange events.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.CheckItem.html#method-setChecked Original Ext JS documentation of 'setChecked'
   */
  public native function setChecked(checked:Boolean, suppressEvents:Boolean = false):void;

  /**
   * Sets the value of <code>publishes</code>.
   * @param publishes The new value.
   * @see #publishes
   */
  override public native function setPublishes(publishes:*):void;
}
}