package ext.menu {
import ext.picker.ColorPicker;

[Native("Ext.menu.ColorPicker", require)]
/**
 * @see ext.menu.events.ColorPickerMenu_colorEvent.SELECT
 * @eventType ext.menu.events.ColorPickerMenu_colorEvent.SELECT
 */
[Event(name='onSelect', type='ext.menu.events.ColorPickerMenu_colorEvent')]
/**
 * A menu containing a Ext.picker.Color Component.
 * <p>Notes:</p>
 * <ul>
 * <li>Although not listed here, the <b>constructor</b> for this class accepts all of the
 * configuration options of →<code>ext.picker.ColorPicker</code>.</li>
 * <li>If subclassing ColorMenu, any configuration options for the ColorPicker must be
 * applied to the <b>initialConfig</b> property of the ColorMenu. Applying
 * →<code>ext.picker.ColorPicker</code> configuration settings to <code>this</code> will <b>not</b>
 * affect the ColorPicker's configuration.</li>
 * </ul>
 * <p>Example:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var colorPicker = Ext.create('Ext.menu.ColorPicker', {
 *     value: '000000'
 * });
 *
 * Ext.create('Ext.menu.Menu', {
 *     items: [{
 *         text: 'Choose a color',
 *         menu: colorPicker
 *     }, {
 *         iconCls: 'add16',
 *         text: 'Icon item'
 *     }, {
 *         text: 'Regular item'
 *     }]
 * }).showAt([5, 5]);
 * </pre>
 * @see ext.picker.ColorPicker
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.ColorPicker.html Original Ext JS documentation of 'Ext.menu.ColorPicker'
 */
public class ColorPickerMenu extends Menu {
  /**
   * @param config @inheritDoc
   */
  public function ColorPickerMenu(config:ColorPickerMenu = null) {
    super();
  }

  [ExtConfig]
  /**
   * False to continue showing the menu after a color is selected.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.ColorPicker.html#cfg-hideOnClick Original Ext JS documentation of 'hideOnClick'
   */
  public native function get hideOnClick():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set hideOnClick(value:Boolean):void;

  /**
   * The →<code>ext.picker.ColorPicker</code> instance for this ColorMenu
   * @see ext.picker.ColorPicker
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.ColorPicker.html#property-picker Original Ext JS documentation of 'picker'
   */
  public native function get picker():ColorPicker;

  /**
   * @private
   */
  public native function set picker(value:ColorPicker):void;

  [ExtConfig]
  /**
   * An id to assign to the underlying color picker.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.ColorPicker.html#cfg-pickerId Original Ext JS documentation of 'pickerId'
   */
  public native function get pickerId():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set pickerId(value:String):void;
}
}