package ext.menu {
import ext.picker.DatePicker;

[Native("Ext.menu.DatePicker", require)]
/**
 * @see ext.menu.events.DatePickerMenu_dateEvent.SELECT
 * @eventType ext.menu.events.DatePickerMenu_dateEvent.SELECT
 */
[Event(name='onSelect', type='ext.menu.events.DatePickerMenu_dateEvent')]
/**
 * A menu containing an Ext.picker.Date Component.
 * <p>Notes:</p>
 * <ul>
 * <li>Although not listed here, the <b>constructor</b> for this class accepts all of the
 * configuration options of <b>→<code>ext.picker.DatePicker</code></b>.</li>
 * <li>If subclassing DateMenu, any configuration options for the DatePicker must be applied
 * to the <b>initialConfig</b> property of the DateMenu. Applying <i>Date Picker</i> (→<code>ext.picker.DatePicker</code>)
 * configuration settings to <b>this</b> will <b>not</b> affect the Date Picker's configuration.</li>
 * </ul>
 * <p>Example:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var dateMenu = Ext.create('Ext.menu.DatePicker', {
 *     handler: function(dp, date){
 *         Ext.Msg.alert('Date Selected', 'You selected ' + Ext.Date.format(date, 'M j, Y'));
 *     }
 * });
 *
 * Ext.create('Ext.menu.Menu', {
 *     items: [{
 *         text: 'Choose a date',
 *         menu: dateMenu
 *     },{
 *         iconCls: 'add16',
 *         text: 'Icon item'
 *     },{
 *         text: 'Regular item'
 *     }]
 * }).showAt([5, 5]);
 * </pre>
 * @see ext.picker.DatePicker
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.DatePicker.html Original Ext JS documentation of 'Ext.menu.DatePicker'
 */
public class DatePickerMenu extends Menu {
  /**
   * @param config @inheritDoc
   */
  public function DatePickerMenu(config:DatePickerMenu = null) {
    super();
  }

  [ExtConfig]
  /**
   * The ARIA label for the Date Picker menu.
   * @default 'Date picker'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.DatePicker.html#cfg-ariaLabel Original Ext JS documentation of 'ariaLabel'
   */
  override public native function get ariaLabel():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set ariaLabel(value:String):void;

  [ExtConfig]
  /**
   * False to continue showing the menu after a date is selected.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.DatePicker.html#cfg-hideOnClick Original Ext JS documentation of 'hideOnClick'
   */
  public native function get hideOnClick():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set hideOnClick(value:Boolean):void;

  /**
   * The →<code>ext.picker.DatePicker</code> instance for this DateMenu
   * @see ext.picker.DatePicker
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.DatePicker.html#property-picker Original Ext JS documentation of 'picker'
   */
  public native function get picker():DatePicker;

  /**
   * @private
   */
  public native function set picker(value:DatePicker):void;

  [ExtConfig]
  /**
   * Date picker configuration. This config
   * takes priority over →<code>pickerId</code>.
   * @see #pickerId
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.DatePicker.html#cfg-pickerCfg Original Ext JS documentation of 'pickerCfg'
   */
  public native function get pickerCfg():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set pickerCfg(value:Object):void;

  [ExtConfig]
  /**
   * An id to assign to the underlying date picker.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.DatePicker.html#cfg-pickerId Original Ext JS documentation of 'pickerId'
   */
  public native function get pickerId():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set pickerId(value:String):void;
}
}