package ext.menu {
import ext.Component;
import ext.mixin.IQueryable;

[Native("Ext.menu.Item", require)]
/**
 * @see ext.menu.events.ItemEvent.ACTIVATE
 * @eventType ext.menu.events.ItemEvent.ACTIVATE
 */
[Event(name='onActivate', type='ext.menu.events.ItemEvent')]
/**
 * @see ext.menu.events.Item_eEvent.CLICK
 * @eventType ext.menu.events.Item_eEvent.CLICK
 */
[Event(name='onClick', type='ext.menu.events.Item_eEvent')]
/**
 * @see ext.menu.events.ItemEvent.DEACTIVATE
 * @eventType ext.menu.events.ItemEvent.DEACTIVATE
 */
[Event(name='onDeactivate', type='ext.menu.events.ItemEvent')]
/**
 * @see ext.menu.events.Item_oldIcon_newIconEvent.ICON_CHANGE
 * @eventType ext.menu.events.Item_oldIcon_newIconEvent.ICON_CHANGE
 */
[Event(name='onIconChange', type='ext.menu.events.Item_oldIcon_newIconEvent')]
/**
 * @see ext.menu.events.Item_oldText_newTextEvent.TEXT_CHANGE
 * @eventType ext.menu.events.Item_oldText_newTextEvent.TEXT_CHANGE
 */
[Event(name='onTextChange', type='ext.menu.events.Item_oldText_newTextEvent')]
/**
 * A base class for all menu items that require menu-related functionality such as click handling,
 * sub-menus, icons, etc.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.menu.Menu', {
 *     width: 100,
 *     height: 100,
 *     floating: false,  // usually you want this set to True (default)
 *     renderTo: Ext.getBody(),  // usually rendered by it's containing component
 *     items: [{
 *         text: 'icon item',
 *         iconCls: 'add16'
 *     }, {
 *         text: 'text item'
 *     }, {
 *         text: 'plain item',
 *         plain: true
 *     }]
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html Original Ext JS documentation of 'Ext.menu.Item'
 */
public class Item extends Component implements IQueryable {
  /**
   * @param config @inheritDoc
   */
  public function Item(config:Item = null) {
    super();
  }

  /**
   * Whether or not this item is currently activated
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#property-activated Original Ext JS documentation of 'activated'
   */
  public native function get activated():Boolean;

  /**
   * @private
   */
  public native function set activated(value:Boolean):void;

  [ExtConfig]
  /**
   * The CSS class added to the menu item when the item is focused.
   * @default Ext.baseCSSPrefix + 'menu-item-active'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#cfg-activeCls Original Ext JS documentation of 'activeCls'
   */
  public native function get activeCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set activeCls(value:String):void;

  /**
   * The name of the Component property that holds
   * a reference to the Element that serves as that Component's ARIA element.
   * This property will be replaced with the actual Element reference after rendering.
   * <p>Most of the simple Components will have their main element as ariaEl.</p>
   * @default 'itemEl'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#property-ariaEl Original Ext JS documentation of 'ariaEl'
   */
  public native function get ariaEl():String;

  /**
   * @private
   */
  public native function set ariaEl(value:String):void;

  /**
   * ARIA role for this Component, defaults to no role.
   * With no role, no other ARIA attributes are set.
   * @default 'menuitem'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#property-ariaRole Original Ext JS documentation of 'ariaRole'
   */
  override public native function get ariaRole():String;

  /**
   * @private
   */
  public native function set ariaRole(value:String):void;

  [ExtConfig]
  /**
   * A tag name or →<code>ext.dom.DomHelper</code> spec used to create the <i>Element</i> (→<code>getEl()</code>)
   * which will encapsulate this Component.
   * <p>You do not normally need to specify this. For the base classes →<code>ext.Component</code> and
   * →<code>ext.container.Container</code>, this defaults to <b>'div'</b>. The more complex Sencha classes
   * use a more complex DOM structure specified by their own →<code>renderTpl</code>s.</p>
   * <p>This is intended to allow the developer to create application-specific utility Components
   * encapsulated by different DOM elements. Example usage:</p>
   * <pre>
   * {
   *     xtype: 'component',
   *     autoEl: {
   *         tag: 'img',
   *         src: 'http://www.example.com/example.jpg'
   *     }
   * }, {
   *     xtype: 'component',
   *     autoEl: {
   *         tag: 'blockquote',
   *         html: 'autoEl is cool!'
   *     }
   * }, {
   *     xtype: 'container',
   *     autoEl: 'ul',
   *     cls: 'ux-unordered-list',
   *     items: {
   *         xtype: 'component',
   *         autoEl: 'li',
   *         html: 'First list item'
   *     }
   * }
   * </pre>
   * @default {
   *     role: 'presentation'
   * }
   * @see ext.dom.#DomHelper ext.dom.DomHelper
   * @see #getEl()
   * @see ext.Component
   * @see ext.container.Container
   * @see #renderTpl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#cfg-autoEl Original Ext JS documentation of 'autoEl'
   */
  override public native function get autoEl():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set autoEl(value:*):void;

  [ExtConfig]
  /**
   * The base CSS class to apply to this component's element. This will also be prepended
   * to elements within this component like Panel's body will get a class <code>x-panel-body</code>.
   * This means that if you create a subclass of Panel, and you want it to get all the Panels
   * styling for the element and the body, you leave the <code>→baseCls</code> <code>x-panel</code> and use
   * <code>→componentCls</code> to add specific styling for this component.
   * @default Ext.baseCSSPrefix + 'menu-item'
   * @see #baseCls
   * @see #componentCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#cfg-baseCls Original Ext JS documentation of 'baseCls'
   */
  override public native function get baseCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set baseCls(value:String):void;

  [Deprecated(replacement="focusable", since="5.1.0")]
  [ExtConfig]
  /**
   * Whether or not this menu item can be focused.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#cfg-canActivate Original Ext JS documentation of 'canActivate'
   */
  public native function get canActivate():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set canActivate(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The canonical form of <code>→childEls</code> is an object keyed by child's property name
   * with values that are objects with the following properties.
   * <ul>
   * <li><code>→itemId</code> - The id to combine with the Component's id that is the id of the
   * child element.</li>
   * <li><code>→id</code> - The id of the child element.</li>
   * <li><code>leaf</code> - Set to <code>true</code> to ignore content when scanning for childEls. This
   * should be set on things like the generated content for an <code>→ext.view.DataView</code>.</li>
   * <li><code>select</code>: A selector that will be passed to →<code>ext.dom.Element.select()</code>.</li>
   * <li><code>selectNode</code>: A selector that will be passed to
   * →<code>ext.dom.Element.selectNode()</code>.</li>
   * </ul>
   * <p>For example:</p>
   * <pre>
   *  childEls: {
   *      button: true,
   *      buttonText: 'text',
   *      buttonImage: {
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above is translated into the following complete form:</p>
   * <pre>
   *  childEls: {
   *      button: {
   *          name: 'button',
   *          itemId: 'button'
   *      },
   *      buttonText: {
   *          name: 'buttonText',
   *          itemId: 'text'
   *      },
   *      buttonImage: {
   *          name: 'buttonImage',
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above can be provided as an array like so:</p>
   * <pre>
   *  childEls: [
   *      'button',
   *      { name: 'buttonText', itemId: 'text' },
   *      { name: 'buttonImage', itemId: 'image' }
   *  }
   * </pre>
   * <p>For example, a Component which renders a title and body text:</p>
   * <p><b>Example:</b></p>
   * <pre>
   * Ext.create('Ext.Component', {
   *     renderTo: Ext.getBody(),
   *     renderTpl: [
   *         '&lt;h1 id="{id}-title" data-ref="title"&gt;{title}&lt;/h1&gt;',
   *         '&lt;p&gt;{msg}&lt;/p&gt;',
   *     ],
   *     renderData: {
   *         title: "Error",
   *         msg: "Something went wrong"
   *     },
   *     childEls: ["title"],
   *     listeners: {
   *         afterrender: function(cmp){
   *             // After rendering the component will have a title property
   *             cmp.title.setStyle({color: "red"});
   *         }
   *     }
   * });
   * </pre>
   * <p><b>Note:</b> <code>childEl</code>s in the →<code>ext.Component.renderTpl</code>
   * must be referenced in a <b>data-ref</b> attribute. Notice in the above example
   * that the "title" <code>childEl</code> is set in the <code>→renderTpl</code> using
   * <b>data-ref="title"</b>.</p>
   * <p>When using <code>select</code>, the property will be an instance of →<code>ext.dom.CompositeElement</code>.
   * In all other cases, the property will be an →<code>ext.dom.Element</code> or <code>null</code>
   * if not found.</p>
   * <p>Care should be taken when using <code>select</code> or <code>selectNode</code> to find child elements.
   * The following issues should be considered:</p>
   * <ul>
   * <li>Performance: using selectors can be 10x slower than id lookup.</li>
   * <li>Over-selecting: selectors are applied after the DOM elements for all children
   * have been rendered, so selectors can match elements from child components
   * (including nested versions of the same component) accidentally.</li>
   * </ul>
   * <p>This above issues are most important when using <code>select</code> since it returns multiple
   * elements.</p>
   * @default [
   *     'itemEl',
   *     'iconEl',
   *     'textEl',
   *     'arrowEl'
   * ]
   * @see #childEls
   * @see #itemId
   * @see #id
   * @see ext.view.DataView
   * @see ext.dom.Element#select()
   * @see ext.dom.Element#selectNode()
   * @see ext.Component#renderTpl
   * @see #renderTpl
   * @see ext.dom.CompositeElement
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#cfg-childEls Original Ext JS documentation of 'childEls'
   * @see #getChildEls()
   * @see #setChildEls()
   */
  override public native function get childEls():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set childEls(value:*):void;

  [ExtConfig]
  /**
   * The delay in milliseconds to wait before hiding the menu after clicking the menu item.
   * This only has an effect when <code>hideOnClick: true</code>.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#cfg-clickHideDelay Original Ext JS documentation of 'clickHideDelay'
   */
  public native function get clickHideDelay():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set clickHideDelay(value:Number):void;

  [ExtConfig]
  /**
   * Whether or not to destroy any associated sub-menu when this item is destroyed.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#cfg-destroyMenu Original Ext JS documentation of 'destroyMenu'
   */
  public native function get destroyMenu():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set destroyMenu(value:Boolean):void;

  [ExtConfig]
  /**
   * The CSS class added to the menu item when the item is disabled.
   * @default Ext.baseCSSPrefix + 'menu-item-disabled'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#cfg-disabledCls Original Ext JS documentation of 'disabledCls'
   */
  override public native function get disabledCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set disabledCls(value:String):void;

  [ExtConfig]
  /**
   * The text to display when the the →<code>text</code> is empty.
   * @default '\xa0'
   * @since 7.2.0
   * @see #text
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#cfg-emptyText Original Ext JS documentation of 'emptyText'
   */
  public native function get emptyText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set emptyText(value:String):void;

  /**
   * <code>true</code> for keyboard interactive Components or Widgets, <code>false</code> otherwise.
   * For Containers, this property reflects interactiveness of the
   * Container itself, not its children. See →<code>isFocusable()</code>.
   * <p><b>Note:</b> It is not enough to set this property to <code>true</code> to make
   * a component keyboard interactive. You also need to make sure that
   * the component's →<code>focusEl</code> is reachable via Tab key (tabbable).
   * See also →<code>tabIndex</code>.</p>
   * @default true
   * @see #isFocusable()
   * @see #focusEl
   * @see #tabIndex
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#property-focusable Original Ext JS documentation of 'focusable'
   */
  override public native function get focusable():Boolean;

  /**
   * @private
   */
  public native function set focusable(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * A numeric unicode character code to use as the icon. The default font-family
   * for glyphs can be set globally using
   * →<code>ext.app.Application.glyphFontFamily</code> application
   * config or the →<code>ext.Ext.setGlyphFontFamily()</code> method.
   * It is initially set to <code>'Pictos'</code>.
   * <p>The following shows how to set the glyph using the font icons provided in the
   * SDK (assuming the font-family has been configured globally):</p>
   * <pre>
   * // assumes the glyphFontFamily is "Pictos"
   * glyph: 'x48'       // the "home" icon (H character)
   *
   * // assumes the glyphFontFamily is "Pictos"
   * glyph: 72          // The "home" icon (H character)
   *
   * // assumes the glyphFontFamily is "Pictos"
   * glyph: 'H'         // the "home" icon
   * </pre>
   * <p>Alternatively, this config option accepts a string with the charCode and
   * font-family separated by the <code>&#64;</code> symbol.</p>
   * <pre>
   * // using Font Awesome
   * glyph: 'xf015&#64;FontAwesome'     // the "home" icon
   *
   * // using Pictos
   * glyph: 'H&#64;Pictos'              // the "home" icon
   * </pre>
   * <p>Depending on the theme you're using, you may need include the font icon
   * packages in your application in order to use the icons included in the
   * SDK. For more information see:</p>
   * <ul>
   * <li><a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/">Font Awesome icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/font_ext.html">Pictos icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/theming.html">Theming Guide</a></li>
   * </ul>
   * @default null
   * @see ext.app.Application#glyphFontFamily
   * @see ext.SExt#setGlyphFontFamily() ext.Ext.setGlyphFontFamily()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#cfg-glyph Original Ext JS documentation of 'glyph'
   * @see #getGlyph()
   * @see #setGlyph()
   */
  public native function get glyph():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set glyph(value:*):void;

  [ExtConfig]
  /**
   * A function called when the menu item is clicked (can be used instead of →<code>event:onClick</code>
   * event).
   * <ul>
   * <li><code>item:ext.menu.Item</code> (optional) —
   * The item that was clicked
   * </li>
   * <li><code>e:ext.event.Event</code> (optional) —
   * The underlying →<code>ext.event.Event</code>.
   * </li>
   * </ul>
   * @see #event:onClick
   * @see ext.event.Event
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#cfg-handler Original Ext JS documentation of 'handler'
   * @see #setHandler()
   */
  public native function get handler():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set handler(value:*):void;

  [ExtConfig]
  /**
   * Whether to not to hide the owning menu when this item is clicked.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#cfg-hideOnClick Original Ext JS documentation of 'hideOnClick'
   */
  public native function get hideOnClick():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set hideOnClick(value:Boolean):void;

  [ExtConfig]
  /**
   * The href attribute to use for the underlying anchor link.
   * @default '#'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#cfg-href Original Ext JS documentation of 'href'
   */
  public native function get href():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set href(value:String):void;

  [ExtConfig]
  /**
   * The target attribute to use for the underlying anchor link.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#cfg-hrefTarget Original Ext JS documentation of 'hrefTarget'
   */
  public native function get hrefTarget():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set hrefTarget(value:String):void;

  [ExtConfig]
  /**
   * Path to an image to use as an icon.
   * <p>For instructions on how you can use icon fonts including those distributed in
   * the SDK see →<code>iconCls</code>.</p>
   * @default Ext#BLANK_IMAGE_URL
   * @see #iconCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#cfg-icon Original Ext JS documentation of 'icon'
   * @see #setIcon()
   */
  public native function get icon():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set icon(value:String):void;

  [ExtConfig]
  /**
   * One or more space separated CSS classes to be applied to the icon element.
   * The CSS rule(s) applied should specify a background image to be used as the
   * icon.
   * <p>An example of specifying a custom icon class would be something like:</p>
   * <pre>
   * // specify the property in the config for the class:
   * iconCls: 'my-home-icon'
   *
   * // css rule specifying the background image to be used as the icon image:
   * .my-home-icon {
   *     background-image: url(../images/my-home-icon.gif) !important;
   * }
   * </pre>
   * <p>In addition to specifying your own classes, you can use the font icons
   * provided in the SDK using the following syntax:</p>
   * <pre>
   * // using Font Awesome
   * iconCls: 'x-fa fa-home'
   *
   * // using Pictos
   * iconCls: 'pictos pictos-home'
   * </pre>
   * <p>Depending on the theme you're using, you may need include the font icon
   * packages in your application in order to use the icons included in the
   * SDK. For more information see:</p>
   * <ul>
   * <li><a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/">Font Awesome icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/font_ext.html">Pictos icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/theming.html">Theming Guide</a></li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#cfg-iconCls Original Ext JS documentation of 'iconCls'
   * @see #setIconCls()
   */
  public native function get iconCls():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set iconCls(value:String):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated Menu Item, or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#property-isMenuItem Original Ext JS documentation of 'isMenuItem'
   */
  public native function get isMenuItem():Boolean;

  /**
   * @private
   */
  public native function set isMenuItem(value:Boolean):void;

  /**
   * This is an internal flag that you use when creating custom components. By default this is set
   * to <code>true</code> which means that every component gets a mask when it's disabled. Components like
   * FieldContainer, FieldSet, Field, Button, Tab override this property to <code>false</code>
   * since they want to implement custom disable logic.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#property-maskOnDisable Original Ext JS documentation of 'maskOnDisable'
   */
  override public native function get maskOnDisable():Boolean;

  /**
   * @private
   */
  override public native function set maskOnDisable(value:Boolean):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The sub-menu associated with this item, if one was configured.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#property-menu Original Ext JS documentation of 'menu'
   * @see #getMenu()
   * @see #setMenu()
   */
  public native function get menu():Menu;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set menu(value:Menu):void;

  [ExtConfig]
  /**
   * The default →<code>ext.util.Positionable.getAlignToXY()</code>
   * anchor position value for this item's sub-menu relative to this item's position.
   * @default 'tl-tr?'
   * @see ext.util.Positionable#getAlignToXY()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#cfg-menuAlign Original Ext JS documentation of 'menuAlign'
   */
  public native function get menuAlign():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set menuAlign(value:String):void;

  [ExtConfig]
  /**
   * The delay in milliseconds before this item's sub-menu expands after this item is moused over.
   * @default 200
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#cfg-menuExpandDelay Original Ext JS documentation of 'menuExpandDelay'
   */
  public native function get menuExpandDelay():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set menuExpandDelay(value:Number):void;

  [ExtConfig]
  /**
   * The delay in milliseconds before this item's sub-menu hides after this item is moused out.
   * @default 200
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#cfg-menuHideDelay Original Ext JS documentation of 'menuHideDelay'
   */
  public native function get menuHideDelay():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set menuHideDelay(value:Number):void;

  /**
   * The parent Menu of this item.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#property-parentMenu Original Ext JS documentation of 'parentMenu'
   */
  public native function get parentMenu():Menu;

  /**
   * @private
   */
  public native function set parentMenu(value:Menu):void;

  [ExtConfig]
  /**
   * Whether or not this item is plain text/html with no icon or visual submenu indication.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#cfg-plain Original Ext JS documentation of 'plain'
   */
  public native function get plain():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set plain(value:Boolean):void;

  [ExtConfig]
  /**
   * An →<code>ext.XTemplate</code> used to create the internal structure inside
   * this Component's encapsulating <i>Element</i> (→<code>getEl()</code>).
   * <p>You do not normally need to specify this. For the base classes →<code>ext.Component</code> and
   * →<code>ext.container.Container</code>, this defaults to <b><code>null</code></b> which means that they will be
   * initially rendered with no internal structure; they render their <i>Element</i> (→<code>getEl()</code>)
   * empty. The more specialized classes with complex DOM structures provide their own template
   * definitions.</p>
   * <p>This is intended to allow the developer to create application-specific utility Components
   * with customized internal structure.</p>
   * <p>Upon rendering, any created child elements may be automatically imported into object
   * properties using the →<code>renderSelectors</code> and →<code>childEls</code> options.</p>
   * @default '<tpl if="plain">' + '{text}' + '<tpl else>' + '<a id="{id}-itemEl" data-ref="itemEl"' + ' class="{linkCls}<tpl if="hasHref"> {linkHrefCls}</tpl>{childElCls}"' + ' href="{href}" ' + '<tpl if="hrefTarget"> target="{hrefTarget}"</tpl>' + ' hidefocus="true"' + // For most browsers the text is already unselectable but Opera needs an explicit unselectable="on".
   * ' unselectable="on"' + '<tpl if="tabIndex != null">' + ' tabindex="{tabIndex}"' + '</tpl>' + '<tpl foreach="ariaAttributes"> {$}="{.}"</tpl>' + '>' + '<span id="{id}-textEl" data-ref="textEl" class="{textCls} {textCls}-{ui} {indentCls}{childElCls}" unselectable="on" role="presentation">{text}</span>' + '<tpl if="hasIcon">' + '<div role="presentation" id="{id}-iconEl" data-ref="iconEl" class="{baseIconCls}-{ui} {baseIconCls}' + '{[values.rightIcon ? "-right" : ""]} {iconCls}' + '{childElCls} {glyphCls}" style="<tpl if="icon">background-image:url({icon});</tpl>' + '<tpl if="glyph">' + '<tpl if="glyphFontFamily">' + 'font-family:{glyphFontFamily};' + '</tpl>' + '">' + '{glyph}' + '<tpl else>' + '">' + '</tpl>' + '</div>' + '</tpl>' + '<tpl if="showCheckbox">' + '<div role="presentation" id="{id}-checkEl" data-ref="checkEl" class="{baseIconCls}-{ui} {baseIconCls}' + '{[(values.hasIcon && !values.rightIcon) ? "-right" : ""]} ' + '{groupCls} {checkboxCls}{childElCls}">' + '</div>' + '</tpl>' + '<tpl if="hasMenu">' + '<div role="presentation" id="{id}-arrowEl" data-ref="arrowEl" class="{arrowCls} {arrowCls}-{ui}{childElCls}"></div>' + '</tpl>' + '</a>' + '</tpl>'
   * @see ext.XTemplate
   * @see #getEl()
   * @see ext.Component
   * @see ext.container.Container
   * @see #renderSelectors
   * @see #childEls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#cfg-renderTpl Original Ext JS documentation of 'renderTpl'
   */
  override public native function get renderTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set renderTpl(value:*):void;

  [ExtConfig]
  /**
   * The text/html to display in this item.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#cfg-text Original Ext JS documentation of 'text'
   * @see #setText()
   */
  public native function get text():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set text(value:String):void;

  [ExtConfig]
  /**
   * The tooltip for the button - can be a string to be used as innerHTML (html tags are accepted)
   * or QuickTips config object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#cfg-tooltip Original Ext JS documentation of 'tooltip'
   * @see #setTooltip()
   */
  public native function get tooltip():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set tooltip(value:*):void;

  [ExtConfig]
  /**
   * The type of tooltip to use. Either 'qtip' for QuickTips or 'title' for title attribute.
   * @default 'qtip'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#cfg-tooltipType Original Ext JS documentation of 'tooltipType'
   */
  public native function get tooltipType():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set tooltipType(value:String):void;

  /**
   * @inheritDoc
   */
  public native function child(selector:* = undefined):Component;

  /**
   * @inheritDoc
   */
  public native function down(selector:* = undefined):Component;

  /**
   * Returns the value of <code>childEls</code>.
   * @see #childEls
   */
  override public native function getChildEls():*;

  /**
   * Returns the value of <code>glyph</code>.
   * @see #glyph
   */
  public native function getGlyph():*;

  /**
   * Get the attached sub-menu for this item.
   * @return The sub-menu. <code>null</code> if it doesn't exist.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#method-getMenu Original Ext JS documentation of 'getMenu'
   */
  public native function getMenu():Menu;

  /**
   * @inheritDoc
   */
  public native function query(selector:String = null):Array;

  /**
   * @inheritDoc
   */
  public native function queryBy(fn:Function, scope:Object = null):Array;

  /**
   * @inheritDoc
   */
  public native function queryById(id:String):Component;

  /**
   * Sets the value of <code>childEls</code>.
   * @param childEls The new value.
   * @see #childEls
   */
  override public native function setChildEls(childEls:*):void;

  /**
   * Sets the value of <code>glyph</code>.
   * @param glyph The new value.
   * @see #glyph
   */
  public native function setGlyph(glyph:*):void;

  /**
   * Sets the →<code>event:onClick</code> handler of this item
   * @param fn The handler function
   * @param scope The scope of the handler function
   * @see #event:onClick
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#method-setHandler Original Ext JS documentation of 'setHandler'
   */
  public native function setHandler(fn:Function, scope:Object = null):void;

  /**
   * Sets the →<code>icon</code> on this item.
   * @param icon The new icon URL. If this <code>MenuItem</code> was configured with a
   * →<code>glyph</code>, this may be a glyph configuration. See →<code>glyph</code>.
   * @see #icon
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#method-setIcon Original Ext JS documentation of 'setIcon'
   * @see #glyph
   */
  public native function setIcon(icon:String):void;

  /**
   * Sets the →<code>iconCls</code> of this item
   * @param iconCls The CSS class to set to →<code>iconCls</code>
   * @see #iconCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#method-setIconCls Original Ext JS documentation of 'setIconCls'
   */
  public native function setIconCls(iconCls:String):void;

  /**
   * Set a child menu for this item. See the →<code>menu</code> configuration.
   * @param menu A menu, or menu configuration. null may be
   * passed to remove the menu.
   * @param destroyMenu True to destroy any existing menu. False to
   * prevent destruction. If not specified, the →<code>destroyMenu</code> configuration
   * will be used.
   * @see #menu
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#method-setMenu Original Ext JS documentation of 'setMenu'
   * @see #destroyMenu
   */
  public native function setMenu(menu:*, destroyMenu:Boolean = false):void;

  /**
   * Sets the →<code>text</code> of this item
   * @param text The →<code>text</code>
   * @see #text
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#method-setText Original Ext JS documentation of 'setText'
   */
  public native function setText(text:String):void;

  /**
   * Sets the tooltip for this menu item.
   * @param tooltip This may be:
   * <ul>
   * <li><b>String</b> : A string to be used as innerHTML (html tags are accepted) to show
   * in a tooltip</li>
   * <li><b>Object</b> : A configuration object for →<code>ext.tip.QuickTipManager.register()</code>.</li>
   * </ul>
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#method-setTooltip Original Ext JS documentation of 'setTooltip'
   * @see ext.tip.SQuickTipManager#register() ext.tip.QuickTipManager.register()
   */
  public native function setTooltip(tooltip:*):Item;

  /**
   * @inheritDoc
   */
  public native function visitPostOrder(selector:Object, fn:Function, scope:Object = null, extraArgs:Array = null):void;

  /**
   * @inheritDoc
   */
  public native function visitPreOrder(selector:Object, fn:Function, scope:Object = null, extraArgs:Array = null):void;
}
}