package ext.menu {
import ext.Component;
import ext.panel.Panel;

[Native("Ext.menu.Menu", require)]
/**
 * @see ext.menu.events.Menu_item_eEvent.CLICK
 * @eventType ext.menu.events.Menu_item_eEvent.CLICK
 */
[Event(name='onClick', type='ext.menu.events.Menu_item_eEvent')]
/**
 * @see ext.menu.events.Menu_eEvent.MOUSE_ENTER
 * @eventType ext.menu.events.Menu_eEvent.MOUSE_ENTER
 */
[Event(name='onMouseEnter', type='ext.menu.events.Menu_eEvent')]
/**
 * @see ext.menu.events.Menu_eEvent.MOUSE_LEAVE
 * @eventType ext.menu.events.Menu_eEvent.MOUSE_LEAVE
 */
[Event(name='onMouseLeave', type='ext.menu.events.Menu_eEvent')]
/**
 * @see ext.menu.events.Menu_item_eEvent.MOUSE_OVER
 * @eventType ext.menu.events.Menu_item_eEvent.MOUSE_OVER
 */
[Event(name='onMouseOver', type='ext.menu.events.Menu_item_eEvent')]
/**
 * A menu object. This is the container to which you may add <i>menu items</i> (→<code>ext.menu.Item</code>).
 * <p>Menus may contain either <i>menu items</i> (→<code>ext.menu.Item</code>), or general
 * <i>Components</i> (→<code>ext.Component</code>). Menus may also contain
 * <i>docked items</i> (→<code>ext.panel.Panel.dockedItems</code>) because it extends →<code>ext.panel.Panel</code>.</p>
 * <p>By default, non <i>menu items</i> (→<code>ext.menu.Item</code>) are indented so that they line up with the text
 * of menu items, clearing the icon column. To make a contained general
 * →<code>ext.Component</code> left aligned configure the child Component with <code>indent: false</code>.</p>
 * <p>By default, Menus are absolutely positioned, floating Components. By configuring a
 * Menu with <code>→floating: false</code>, a Menu may be used as a child of a
 * →<code>ext.container.Container</code>.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.menu.Menu', {
 *     width: 100,
 *     margin: '0 0 10 0',
 *     floating: false,  // usually you want this set to True (default)
 *     renderTo: Ext.getBody(),  // usually rendered by it's containing component
 *     items: [{
 *         text: 'regular item 1'
 *     }, {
 *         text: 'regular item 2'
 *     }, {
 *         text: 'regular item 3'
 *     }]
 * });
 *
 * Ext.create('Ext.menu.Menu', {
 *     width: 100,
 *     plain: true,
 *     floating: false,  // usually you want this set to True (default)
 *     renderTo: Ext.getBody(),  // usually rendered by it's containing component
 *     items: [{
 *         text: 'plain item 1'
 *     }, {
 *         text: 'plain item 2'
 *     }, {
 *         text: 'plain item 3'
 *     }]
 * });
 * </pre>
 * @see ext.menu.Item
 * @see ext.Component
 * @see ext.panel.Panel#dockedItems
 * @see ext.panel.Panel
 * @see #floating
 * @see ext.container.Container
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Menu.html Original Ext JS documentation of 'Ext.menu.Menu'
 */
public class Menu extends Panel {
  /**
   * @param config @inheritDoc
   */
  public function Menu(config:Menu = null) {
    super();
  }

  [ExtConfig]
  /**
   * True to allow multiple menus to be displayed at the same time.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Menu.html#cfg-allowOtherMenus Original Ext JS documentation of 'allowOtherMenus'
   */
  public native function get allowOtherMenus():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set allowOtherMenus(value:Boolean):void;

  [ExtConfig]
  /**
   * The default <i>Ext.dom.Element.getAlignToXY</i> (→<code>ext.util.Positionable.getAlignToXY()</code>)
   * anchor position value for this menu relative to its owner. Used in conjunction with
   * →<code>showBy()</code>.
   * @default "tl-bl?"
   * @see ext.util.Positionable#getAlignToXY()
   * @see #showBy()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Menu.html#cfg-defaultAlign Original Ext JS documentation of 'defaultAlign'
   */
  override public native function get defaultAlign():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set defaultAlign(value:String):void;

  [Deprecated(message="Intra-menu key navigation is always enabled.\n", since="5.1.0")]
  [ExtConfig]
  /**
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Menu.html#cfg-enableKeyNav Original Ext JS documentation of 'enableKeyNav'
   */
  public native function get enableKeyNav():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableKeyNav(value:Boolean):void;

  [ExtConfig]
  /**
   * A Menu configured as <code>floating: true</code> (the default) will be rendered as an
   * absolutely positioned,
   * →<code>ext.Component.floating</code> →<code>ext.Component</code>. If
   * configured as <code>floating: false</code>, the Menu may be used as a child item of another
   * →<code>ext.container.Container</code>.
   * @default true
   * @see ext.Component#floating
   * @see ext.Component
   * @see ext.container.Container
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Menu.html#cfg-floating Original Ext JS documentation of 'floating'
   */
  override public native function get floating():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set floating(value:Boolean):void;

  [ExtConfig]
  /**
   * Specifies whether the floated component should be automatically
   * <i>focused</i> (→<code>ext.Component.focus()</code>) when it is <i>brought to the front</i> (→<code>toFront()</code>).
   * @default false
   * @see ext.Component#focus()
   * @see #toFront()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Menu.html#cfg-focusOnToFront Original Ext JS documentation of 'focusOnToFront'
   */
  override public native function get focusOnToFront():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set focusOnToFront(value:Boolean):void;

  [ExtConfig]
  /**
   * True to initially render the Menu as hidden, requiring to be shown manually.
   * <p>Defaults to <code>true</code> when <code>floating: true</code>, and defaults to <code>false</code> when <code>floating: false</code>.</p>
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Menu.html#cfg-hidden Original Ext JS documentation of 'hidden'
   * @see #setHidden()
   */
  override public native function get hidden():Boolean;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set hidden(value:Boolean):void;

  [ExtConfig]
  /**
   * True to ignore clicks on any item in this menu that is a parent item (displays a submenu)
   * so that the submenu is not dismissed when clicking the parent item.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Menu.html#cfg-ignoreParentClicks Original Ext JS documentation of 'ignoreParentClicks'
   */
  public native function get ignoreParentClicks():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ignoreParentClicks(value:Boolean):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated Menu, or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Menu.html#property-isMenu Original Ext JS documentation of 'isMenu'
   */
  public native function get isMenu():Boolean;

  /**
   * @private
   */
  public native function set isMenu(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The minimum width of the Menu. The default minWidth only applies when the
   * →<code>floating</code> config is true.
   * @default 120
   * @see #floating
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Menu.html#cfg-minWidth Original Ext JS documentation of 'minWidth'
   * @see #getMinWidth()
   * @see #setMinWidth()
   */
  override public native function get minWidth():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set minWidth(value:Number):void;

  [ExtConfig]
  /**
   * The delay in ms as to how long the framework should wait before firing a mouseleave event.
   * This allows submenus not to be collapsed while hovering other menu items.
   * <p>Defaults to 50</p>
   * @default 50
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Menu.html#cfg-mouseLeaveDelay Original Ext JS documentation of 'mouseLeaveDelay'
   */
  public native function get mouseLeaveDelay():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set mouseLeaveDelay(value:Number):void;

  /**
   * The parent Menu of this Menu.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Menu.html#property-parentMenu Original Ext JS documentation of 'parentMenu'
   */
  public native function get parentMenu():Menu;

  /**
   * @private
   */
  public native function set parentMenu(value:Menu):void;

  [ExtConfig]
  /**
   * True to remove the incised line down the left side of the menu and to not indent general
   * Component items.
   * <p><i>MenuItem</i> (→<code>ext.menu.Item</code>)s will <i>always</i> have space at their start for an icon.
   * With the <code>→plain</code> setting, non <i>MenuItem</i> (→<code>ext.menu.Item</code>) child components will not
   * be indented to line up.</p>
   * <p>Basically, <code>plain:true</code> makes a Menu behave more like a regular
   * <i>HBox layout</i> (→<code>ext.layout.container.HBoxLayout</code>) →<code>ext.panel.Panel</code>
   * which just has the same background as a Menu.</p>
   * <p>See also the →<code>showSeparator</code> config.</p>
   * @default false
   * @see ext.menu.Item
   * @see #plain
   * @see ext.layout.container.HBoxLayout
   * @see ext.panel.Panel
   * @see #showSeparator
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Menu.html#cfg-plain Original Ext JS documentation of 'plain'
   */
  public native function get plain():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set plain(value:Boolean):void;

  [ExtConfig]
  /**
   * True to show the icon separator.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Menu.html#cfg-showSeparator Original Ext JS documentation of 'showSeparator'
   */
  public native function get showSeparator():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set showSeparator(value:Boolean):void;

  /**
   * @param item The child item to test for focusability.
   * Returns whether a menu item can be activated or not.
   * @return <code>true</code> if the passed item is focusable.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Menu.html#method-canActivateItem Original Ext JS documentation of 'canActivateItem'
   */
  public native function canActivateItem(item:Component):Boolean;

  /**
   * Deactivates the current active item on the menu, if one exists.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Menu.html#method-deactivateActiveItem Original Ext JS documentation of 'deactivateActiveItem'
   */
  public native function deactivateActiveItem():void;
}
}