package ext.menu {

[Native("Ext.menu.Bar", require)]
/**
 * Horizontal Menu bar widget, a specialized version of the →<code>ext.menu.Menu</code>.
 * <p><b>Example:</b></p>
 * <pre>
 *  new Ext.menu.Bar({
 *      renderTo: Ext.getBody(),
 *      width: 200,
 *      items: [{
 *          text: 'File',
 *          menu: [
 *              { text: 'Open...' },
 *              '-',
 *              { text: 'Close' }
 *          ]
 *      }, {
 *          text: 'Edit',
 *          menu: [
 *              { text: 'Cut' },
 *              { text: 'Copy' }
 *              { text: 'Paste' }
 *          ]
 *      }]
 *  });
 * </pre>
 * @see ext.menu.Menu
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Bar.html Original Ext JS documentation of 'Ext.menu.Bar'
 */
public class MenuBar extends Menu {
  /**
   * @inheritDoc
   */
  public function MenuBar(config:Menu = null) {
    super();
  }

  [ExtConfig]
  /**
   * The default →<code>ext.menu.Item.menuAlign</code> config
   * for direct child items of this Menu bar.
   * @default 'tl-bl?'
   * @see ext.menu.Item#menuAlign
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Bar.html#cfg-defaultMenuAlign Original Ext JS documentation of 'defaultMenuAlign'
   */
  public native function get defaultMenuAlign():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set defaultMenuAlign(value:String):void;
}
}