package ext.menu {
import ext.Base;

[Native]
/**
 * Provides a common registry groups of →<code>ext.menu.CheckItem</code>s.
 * <p>Since 5.1.0, this class no longer registers all menus in your applications.
 * To access all menus, use →<code>ext.ComponentQuery</code>.</p>
 * <p>Type of singleton MenuManager.</p>
 * @see ext.menu.CheckItem
 * @see ext.#ComponentQuery ext.ComponentQuery
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Manager.html Original Ext JS documentation of 'Ext.menu.Manager'
 * @see ext.menu.#MenuManager ext.menu.MenuManager
 */
public class SMenuManager extends Base {
  /**
   * Returns a →<code>ext.menu.Menu</code> object
   * @param menu The string menu id, an existing menu object reference,
   * or a Menu config that will be used to generate and return a new Menu this.
   * @param config A configuration to use when creating the menu.
   * @return The specified menu, or null if none are found
   * @see ext.menu.Menu
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Manager.html#method-get Original Ext JS documentation of 'get'
   */
  public native function get(menu:*, config:Object = null):Menu;

  /**
   * Hides all floating menus that are currently visible
   * @return success True if any active menus were hidden.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Manager.html#method-hideAll Original Ext JS documentation of 'hideAll'
   */
  public native function hideAll():Boolean;
}
}