package ext.menu {

[Native("Ext.menu.Separator", require)]
/**
 * Adds a separator bar to a menu, used to divide logical groups of menu items. Generally you will
 * add one of these by using "-" in your call to add() or in your items config rather than creating
 * one directly.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.menu.Menu', {
 *     width: 100,
 *     height: 100,
 *     floating: false,  // usually you want this set to True (default)
 *     renderTo: Ext.getBody(),  // usually rendered by it's containing component
 *     items: [{
 *         text: 'icon item',
 *         iconCls: 'add16'
 *     },{
 *         xtype: 'menuseparator'
 *     },{
 *        text: 'separator above'
 *     },{
 *        text: 'regular item'
 *     }]
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Separator.html Original Ext JS documentation of 'Ext.menu.Separator'
 */
public class Separator extends Item {
  /**
   * @param config @inheritDoc
   */
  public function Separator(config:Separator = null) {
    super();
  }

  [ExtConfig]
  /**
   * The CSS class used by the separator item to show the incised line.
   * @default Ext.baseCSSPrefix + 'menu-item-separator'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Separator.html#cfg-separatorCls Original Ext JS documentation of 'separatorCls'
   */
  public native function get separatorCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set separatorCls(value:String):void;
}
}